/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutatestring;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.plugins.processor.mutatestring.StringProcessorConfig;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>replace_string</code> processor replaces all occurrence of substring in key\u2019s value with a replacement string.")
public class ReplaceStringProcessorConfig
implements StringProcessorConfig<Entry> {
    @JsonPropertyDescription(value="List of entries. Each entry defines a replacement.")
    private List<Entry> entries;

    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    public List<Entry> getIterativeConfig() {
        return this.entries;
    }

    @JsonPropertyOrder
    public static class Entry {
        @JsonPropertyDescription(value="The key of the field to modify.")
        private EventKey source;
        @JsonPropertyDescription(value="The substring to be replaced in the source.")
        private String from;
        @JsonPropertyDescription(value="The string to be replaced for each match of <code>from</code>.")
        private String to;
        @JsonProperty(value="replace_when")
        @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>, such as <code>/some-key == \"test\"'</code>, that will be evaluated to determine whether the processor will be run on the event. By default, all events will be processed unless otherwise stated.")
        private String replaceWhen;

        public EventKey getSource() {
            return this.source;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getReplaceWhen() {
            return this.replaceWhen;
        }

        public Entry(EventKey source, String from, String to, String replaceWhen) {
            this.source = source;
            this.from = from;
            this.to = to;
            this.replaceWhen = replaceWhen;
        }

        public Entry() {
        }
    }
}

