/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.sink;

import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.Instant;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.event.EventHandle;

public class SinkLatencyMetrics {
    public static final String INTERNAL_LATENCY = "PipelineLatency";
    public static final String EXTERNAL_LATENCY = "EndToEndLatency";
    private final Timer internalLatencyTimer;
    private final Timer externalLatencyTimer;

    public SinkLatencyMetrics(PluginMetrics pluginMetrics) {
        this.internalLatencyTimer = pluginMetrics.timer(INTERNAL_LATENCY);
        this.externalLatencyTimer = pluginMetrics.timer(EXTERNAL_LATENCY);
    }

    public void update(EventHandle eventHandle) {
        Instant now = Instant.now();
        this.internalLatencyTimer.record(Duration.between(eventHandle.getInternalOriginationTime(), now));
        if (eventHandle.getExternalOriginationTime() == null) {
            return;
        }
        this.externalLatencyTimer.record(Duration.between(eventHandle.getExternalOriginationTime(), now));
    }
}

