/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.InternalEventHandle;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.SinkContext;

public class SinkForwardRecordsContext {
    List<Record<Event>> records;
    boolean forwardPipelinesPresent;

    public SinkForwardRecordsContext(SinkContext sinkContext) {
        this.forwardPipelinesPresent = sinkContext != null && sinkContext.getForwardToPipelines().size() > 0;
        this.records = new ArrayList<Record<Event>>();
    }

    public void addRecord(Record<Event> record) {
        if (!this.forwardPipelinesPresent) {
            return;
        }
        InternalEventHandle eventHandle = (InternalEventHandle)((Object)record.getData().getEventHandle());
        if (eventHandle != null) {
            eventHandle.acquireReference();
        }
        this.records.add(record);
    }

    public void addRecords(Collection<Record<Event>> newRecords) {
        if (!this.forwardPipelinesPresent) {
            return;
        }
        newRecords.forEach(record -> {
            Event event = (Event)record.getData();
            InternalEventHandle eventHandle = (InternalEventHandle)((Object)event.getEventHandle());
            if (eventHandle != null) {
                eventHandle.acquireReference();
            }
        });
        this.records.addAll(newRecords);
    }

    public List<Record<Event>> getRecords() {
        return this.records;
    }
}

