/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.opensearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum OpenSearchBulkActions {
    CREATE("create"),
    UPSERT("upsert"),
    UPDATE("update"),
    DELETE("delete"),
    INDEX("index");

    private static final Map<String, OpenSearchBulkActions> ACTIONS_MAP;
    private final String action;

    private OpenSearchBulkActions(String action) {
        this.action = action.toLowerCase();
    }

    public String toString() {
        return this.action;
    }

    @JsonCreator
    public static OpenSearchBulkActions fromOptionValue(String option) {
        return ACTIONS_MAP.get(option.toLowerCase());
    }

    static {
        ACTIONS_MAP = Arrays.stream(OpenSearchBulkActions.values()).collect(Collectors.toMap(value -> value.action, value -> value));
    }
}

