/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.opensearch.dataprepper.model.constraints.ByteCountMax;
import org.opensearch.dataprepper.model.types.ByteCount;

public class ByteCountMaxValidator
implements ConstraintValidator<ByteCountMax, ByteCount> {
    private ByteCount maxByteCount;

    public void initialize(ByteCountMax constraint) {
        this.maxByteCount = ByteCount.parse(constraint.value());
    }

    public boolean isValid(ByteCount byteCount, ConstraintValidatorContext context) {
        if (byteCount == null) {
            return true;
        }
        if (byteCount.compareTo(this.maxByteCount) > 0) {
            if (context != null) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(String.format("The provided byte count %s exceeds maximum of %s", byteCount, this.maxByteCount)).addConstraintViolation();
            }
            return false;
        }
        return true;
    }
}

