/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.model;

import com.google.common.base.Preconditions;
import org.opensearch.dataprepper.logstash.model.LogstashAttributeValue;

public class LogstashAttribute {
    private final String attributeName;
    private final LogstashAttributeValue attributeValue;

    public String getAttributeName() {
        return this.attributeName;
    }

    public LogstashAttributeValue getAttributeValue() {
        return this.attributeValue;
    }

    private LogstashAttribute(Builder builder) {
        Preconditions.checkNotNull((Object)builder.attributeName, (Object)"attribute name cannot be null");
        Preconditions.checkNotNull((Object)builder.attributeValue, (Object)"attribute value cannot be null");
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String attributeName;
        private LogstashAttributeValue attributeValue;

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public Builder attributeValue(LogstashAttributeValue attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public LogstashAttribute build() {
            return new LogstashAttribute(this);
        }
    }
}

