/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.logstash.mapping.GrokLogstashPluginAttributeMapperHelper;
import org.opensearch.dataprepper.logstash.mapping.GrokNamedCapturesUtil;
import org.opensearch.dataprepper.logstash.mapping.LogstashAttributesMappings;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;

class GrokPatternDefinitionsAttributeHelper
implements GrokLogstashPluginAttributeMapperHelper {
    private final Map<String, String> patternDefinitions = new HashMap<String, String>();

    GrokPatternDefinitionsAttributeHelper() {
    }

    @Override
    public void populateAttributes(LogstashAttribute logstashAttribute) {
        this.patternDefinitions.putAll((Map)logstashAttribute.getAttributeValue().getValue());
    }

    @Override
    public void updatePluginSettings(LogstashAttributesMappings logstashAttributesMappings, Map<String, Object> pluginSettings) {
        if (!this.patternDefinitions.isEmpty()) {
            pluginSettings.put(logstashAttributesMappings.getMappedAttributeNames().get("pattern_definitions"), this.patternDefinitions);
        }
    }

    public void fixNamedCaptures(Map<String, List<String>> mergedMatch) {
        for (Map.Entry<String, List<String>> entry : mergedMatch.entrySet()) {
            List<GrokNamedCapturesUtil.GrokNamedCapturesPair> grokNamedCapturesPairs = entry.getValue().stream().map(GrokNamedCapturesUtil::convertRegexNamedCapturesToGrokPatternDefinitions).collect(Collectors.toList());
            grokNamedCapturesPairs.forEach(grokNamedCapturesPair -> this.patternDefinitions.putAll(grokNamedCapturesPair.getMappedPatternDefinitions()));
            List fixedNameCapturesPatterns = grokNamedCapturesPairs.stream().map(GrokNamedCapturesUtil.GrokNamedCapturesPair::getMappedRegex).collect(Collectors.toList());
            entry.setValue(fixedNameCapturesPatterns);
        }
    }
}

