/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.logstash.mapping.GrokLogstashPluginAttributeMapperHelper;
import org.opensearch.dataprepper.logstash.mapping.GrokMatchUtil;
import org.opensearch.dataprepper.logstash.mapping.LogstashAttributesMappings;
import org.opensearch.dataprepper.logstash.mapping.NestedSyntaxConverter;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;
import org.opensearch.dataprepper.logstash.model.LogstashValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrokMatchAttributeHelper
implements GrokLogstashPluginAttributeMapperHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GrokMatchAttributeHelper.class);
    private final List<LogstashAttribute> matchAttributes = new ArrayList<LogstashAttribute>();
    private final Map<String, List<String>> dataPrepperGrokMatch = new HashMap<String, List<String>>();

    GrokMatchAttributeHelper() {
    }

    @Override
    public void populateAttributes(LogstashAttribute logstashAttribute) {
        this.matchAttributes.add(logstashAttribute);
    }

    @Override
    public void updatePluginSettings(LogstashAttributesMappings logstashAttributesMappings, Map<String, Object> pluginSettings) {
        if (!this.dataPrepperGrokMatch.isEmpty()) {
            pluginSettings.put(logstashAttributesMappings.getMappedAttributeNames().get("match"), this.dataPrepperGrokMatch);
        }
    }

    public Map<String, List<String>> mergeMatchAttributes() {
        this.matchAttributes.forEach(matchLogstashAttribute -> {
            LogstashValueType logstashGrokMatchValueType = matchLogstashAttribute.getAttributeValue().getAttributeValueType();
            Object logstashGrokMatchValue = matchLogstashAttribute.getAttributeValue().getValue();
            if (logstashGrokMatchValueType.equals((Object)LogstashValueType.HASH)) {
                Map logstashGrokMatchCastValue = (Map)logstashGrokMatchValue;
                logstashGrokMatchCastValue.forEach((key, val) -> {
                    String grokMatchKey = NestedSyntaxConverter.convertNestedSyntaxToJsonPointer(key);
                    if (!this.dataPrepperGrokMatch.containsKey(grokMatchKey)) {
                        this.dataPrepperGrokMatch.put(grokMatchKey, new ArrayList());
                    }
                    this.dataPrepperGrokMatch.get(grokMatchKey).add(GrokMatchUtil.convertGrokMatchPattern(val));
                });
            } else if (logstashGrokMatchValueType.equals((Object)LogstashValueType.ARRAY)) {
                List logstashGrokMatchCastValue = (List)logstashGrokMatchValue;
                if (logstashGrokMatchCastValue.size() == 2) {
                    String key2 = (String)logstashGrokMatchCastValue.get(0);
                    String val2 = GrokMatchUtil.convertGrokMatchPattern((String)logstashGrokMatchCastValue.get(1));
                    String grokMatchKey = NestedSyntaxConverter.convertNestedSyntaxToJsonPointer(key2);
                    if (!this.dataPrepperGrokMatch.containsKey(grokMatchKey)) {
                        this.dataPrepperGrokMatch.put(grokMatchKey, new ArrayList());
                    }
                    this.dataPrepperGrokMatch.get(grokMatchKey).add(val2);
                } else {
                    LOG.warn("logstash grok filter match attribute array should be of size 2");
                }
            } else {
                LOG.warn("Unsupported logstash grok filter match attribute type");
            }
        });
        return this.dataPrepperGrokMatch;
    }
}

