/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.logstash.mapping.LogstashAttributesMappings;
import org.opensearch.dataprepper.logstash.mapping.LogstashPluginAttributesMapper;
import org.opensearch.dataprepper.logstash.mapping.NestedSyntaxConverter;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogstashPluginAttributesMapper
implements LogstashPluginAttributesMapper {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLogstashPluginAttributesMapper.class);

    @Override
    public List<PluginModel> mapAttributes(List<LogstashAttribute> logstashAttributes, LogstashAttributesMappings logstashAttributesMappings) {
        Objects.requireNonNull(logstashAttributes);
        Objects.requireNonNull(logstashAttributesMappings);
        Objects.requireNonNull(logstashAttributesMappings.getMappedAttributeNames());
        Objects.requireNonNull(logstashAttributesMappings.getAdditionalAttributes());
        Objects.requireNonNull(logstashAttributesMappings.getDefaultSettings());
        LinkedHashMap<String, Object> pluginSettings = new LinkedHashMap<String, Object>(logstashAttributesMappings.getAdditionalAttributes());
        Map<String, String> mappedAttributeNames = logstashAttributesMappings.getMappedAttributeNames();
        Map<String, Object> defaultSettings = logstashAttributesMappings.getDefaultSettings();
        HashSet<String> customMappedAttributeNames = this.getCustomMappedAttributeNames();
        logstashAttributes.stream().filter(logstashAttribute -> !customMappedAttributeNames.contains(logstashAttribute.getAttributeName())).forEach(logstashAttribute -> {
            String logstashAttributeName = logstashAttribute.getAttributeName();
            String dataPrepperAttributeName = (String)mappedAttributeNames.get(logstashAttributeName);
            if (mappedAttributeNames.containsKey(logstashAttributeName)) {
                Object logstashAttributeValue = logstashAttribute.getAttributeValue().getValue();
                if (dataPrepperAttributeName.startsWith("!") && logstashAttribute.getAttributeValue().getValue() instanceof Boolean) {
                    pluginSettings.put(dataPrepperAttributeName.substring(1), (Boolean)logstashAttributeValue == false);
                } else {
                    if (logstashAttributesMappings.getNestedSyntaxAttributeNames().contains(logstashAttributeName)) {
                        logstashAttributeValue = NestedSyntaxConverter.convertNestedSyntaxToJsonPointer(logstashAttributeValue.toString());
                    }
                    pluginSettings.put(dataPrepperAttributeName, logstashAttributeValue);
                }
            } else {
                LOG.warn("Logstash Attribute {} is not supported in Data Prepper.", (Object)logstashAttributeName);
            }
        });
        for (Map.Entry<String, Object> defaultSetting : defaultSettings.entrySet()) {
            if (pluginSettings.containsKey(defaultSetting.getKey())) continue;
            pluginSettings.put(defaultSetting.getKey(), defaultSetting.getValue());
        }
        if (!customMappedAttributeNames.isEmpty()) {
            this.mapCustomAttributes(logstashAttributes, logstashAttributesMappings, pluginSettings);
        }
        LinkedList<PluginModel> pluginModels = new LinkedList<PluginModel>();
        pluginModels.add(new PluginModel(logstashAttributesMappings.getPluginName(), pluginSettings));
        return pluginModels;
    }

    protected abstract void mapCustomAttributes(List<LogstashAttribute> var1, LogstashAttributesMappings var2, Map<String, Object> var3);

    protected abstract HashSet<String> getCustomMappedAttributeNames();
}

