/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecordType {
    SRV("SRV"),
    A("A"),
    AAAA("AAAA"),
    CNAME("CNAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecordType> VALUE_MAP;
    private final String value;

    private RecordType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecordType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecordType> knownValues() {
        EnumSet<RecordType> knownValues = EnumSet.allOf(RecordType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecordType.class, RecordType::toString);
    }
}

