/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.serialization;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.state.RandomCutForestState;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonExample
implements Example {
    public static void main(String[] args) throws Exception {
        new JsonExample().run();
    }

    @Override
    public String command() {
        return "json";
    }

    @Override
    public String description() {
        return "serialize a Random Cut Forest as a JSON string";
    }

    @Override
    public void run() throws Exception {
        int dimensions = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_64;
        RandomCutForest forest = RandomCutForest.builder().compact(true).dimensions(dimensions).numberOfTrees(numberOfTrees).sampleSize(sampleSize).precision(precision).build();
        int dataSize = 4 * sampleSize;
        NormalMixtureTestData testData = new NormalMixtureTestData();
        for (double[] point : testData.generateTestData(dataSize, dimensions)) {
            forest.update(point);
        }
        RandomCutForestMapper mapper = new RandomCutForestMapper();
        mapper.setSaveExecutorContextEnabled(true);
        ObjectMapper jsonMapper = new ObjectMapper();
        String json = jsonMapper.writeValueAsString((Object)mapper.toState(forest));
        System.out.printf("dimensions = %d, numberOfTrees = %d, sampleSize = %d, precision = %s%n", dimensions, numberOfTrees, sampleSize, precision);
        System.out.printf("JSON size = %d bytes%n", json.getBytes().length);
        RandomCutForest forest2 = mapper.toModel((RandomCutForestState)jsonMapper.readValue(json, RandomCutForestState.class));
        int testSize = 100;
        double delta = Math.log(sampleSize) / Math.log(2.0) * 0.05;
        int differences = 0;
        int anomalies = 0;
        for (double[] point : testData.generateTestData(testSize, dimensions)) {
            double score = forest.getAnomalyScore(point);
            double score2 = forest2.getAnomalyScore(point);
            if (score > 1.0 || score2 > 1.0) {
                ++anomalies;
                if (Math.abs(score - score2) > delta) {
                    ++differences;
                }
            }
            forest.update(point);
            forest2.update(point);
        }
        if (anomalies == 0) {
            throw new IllegalStateException("test data did not produce any anomalies");
        }
        if ((double)differences >= 0.01 * (double)testSize) {
            throw new IllegalStateException("restored forest does not agree with original forest");
        }
        System.out.println("Looks good!");
    }
}

