/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.GlobalLocalAnomalyDetector;
import com.amazon.randomcutforest.parkservices.returntypes.GenericAnomalyDescriptor;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.util.Weighted;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;

public class StringGLADexample
implements Example {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_BLUE = "\u001b[34m";

    public static void main(String[] args) throws Exception {
        new StringGLADexample().run();
    }

    @Override
    public String command() {
        return "Clustering based Global-Local Anomaly Detection Example for strings";
    }

    @Override
    public String description() {
        return "Clustering based Global-Local Anomaly Detection Example for strings";
    }

    @Override
    public void run() throws Exception {
        long seed = new Random().nextLong();
        System.out.println("seed : " + seed);
        Random random = new Random(seed);
        int stringSize = 70;
        int numberOfStrings = 200000;
        int reservoirSize = 2000;
        boolean changeInMiddle = true;
        double gapProbOfA = 0.85;
        double anomalyRate = 0.05;
        char[][] points = new char[numberOfStrings][];
        boolean[] injected = new boolean[numberOfStrings];
        boolean printClusters = true;
        boolean printFalseNeg = false;
        boolean printFalsePos = false;
        int numberOfInjected = 0;
        for (int i = 0; i < numberOfStrings; ++i) {
            if (random.nextDouble() < anomalyRate && i > reservoirSize / 2) {
                injected[i] = true;
                ++numberOfInjected;
                points[i] = this.getABArray(stringSize + 10, 0.5, random, false, 0.0);
                continue;
            }
            boolean flag = changeInMiddle && random.nextDouble() < 0.25;
            double prob = random.nextDouble() < 0.5 ? gapProbOfA : 1.0 - gapProbOfA;
            points[i] = this.getABArray(stringSize, prob, random, flag, 0.25 * (double)i / (double)numberOfStrings);
        }
        System.out.println("Injected " + numberOfInjected + " 'anomalies' in " + points.length);
        int recluster = reservoirSize / 2;
        BiFunction<char[], char[], Double> dist = (a, b) -> StringGLADexample.toyD(a, b, (double)stringSize / 2.0);
        GlobalLocalAnomalyDetector reservoir = ((GlobalLocalAnomalyDetector.Builder)((GlobalLocalAnomalyDetector.Builder)((GlobalLocalAnomalyDetector.Builder)GlobalLocalAnomalyDetector.builder().randomSeed(42L)).numberOfRepresentatives(5).timeDecay(1.0 / (double)reservoirSize)).capacity(reservoirSize)).build();
        reservoir.setGlobalDistance(dist);
        int truePos = 0;
        int falsePos = 0;
        int falseNeg = 0;
        for (int y = 0; y < points.length; ++y) {
            GenericAnomalyDescriptor result = reservoir.process((Object)points[y], 1.0f, null, true);
            if (result.getAnomalyGrade() > 0.0) {
                if (!injected[y]) {
                    ++falsePos;
                    List list = result.getRepresentativeList();
                    if (printFalsePos) {
                        System.out.println(result.getScore() + " " + injected[y] + " at " + y + " dist " + dist.apply(points[y], (char[])((Weighted)list.get((int)0)).index) + " " + result.getThreshold());
                        StringGLADexample.printCharArray((char[])((Weighted)list.get((int)0)).index);
                        System.out.println();
                        StringGLADexample.printCharArray(points[y]);
                        System.out.println();
                    }
                } else {
                    ++truePos;
                }
            } else if (injected[y]) {
                ++falseNeg;
                if (printFalseNeg) {
                    System.out.println(" missed " + result.getScore() + "  " + result.getThreshold());
                }
            }
            if (printClusters && y % 10000 == 0 && y > 0) {
                System.out.println(" at " + y);
                this.printClusters(reservoir.getClusters());
            }
            if (10 * y % points.length != 0 || y <= 0) continue;
            System.out.println(" at " + y);
            System.out.println("Precision = " + this.precision(truePos, falsePos));
            System.out.println("Recall = " + this.recall(truePos, falseNeg));
        }
        System.out.println(" Final: ");
        System.out.println("Precision = " + this.precision(truePos, falsePos));
        System.out.println("Recall = " + this.recall(truePos, falseNeg));
    }

    public static double toyD(char[] a, char[] b, double u) {
        if (a.length > b.length) {
            return StringGLADexample.toyD(b, a, u);
        }
        double[][] dist = new double[2][b.length + 1];
        for (int j = 0; j < b.length + 1; ++j) {
            dist[0][j] = j;
        }
        for (int i = 1; i < a.length + 1; ++i) {
            int j;
            dist[1][0] = i;
            for (j = 1; j < b.length + 1; ++j) {
                double t = dist[0][j - 1] + (double)(a[i - 1] != b[j - 1] ? 1 : 0);
                dist[1][j] = Math.min(Math.min(t, dist[0][j] + 1.0), dist[1][j - 1] + 1.0);
            }
            for (j = 0; j < b.length + 1; ++j) {
                dist[0][j] = dist[1][j];
            }
        }
        return dist[1][b.length];
    }

    public static void printCharArray(char[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '-') {
                System.out.print(ANSI_RED + a[i] + ANSI_RESET);
                continue;
            }
            System.out.print(ANSI_BLUE + a[i] + ANSI_RESET);
        }
    }

    public void printClusters(List<ICluster<char[]>> summary) {
        for (int i = 0; i < summary.size(); ++i) {
            double weight = summary.get(i).getWeight();
            System.out.println("Cluster " + i + " representatives, weight " + (double)Math.round(1000.0 * weight) * 0.001 + " avg radius " + summary.get(i).averageRadius());
            List representatives = summary.get(i).getRepresentatives();
            for (int j = 0; j < representatives.size(); ++j) {
                double t = ((Weighted)representatives.get((int)j)).weight;
                t = (double)Math.round(1000.0 * t / weight) * 0.001;
                System.out.print("relative weight " + (float)t + " length " + ((char[])((Weighted)representatives.get((int)j)).index).length + " ");
                StringGLADexample.printCharArray((char[])((Weighted)representatives.get((int)j)).index);
                System.out.println();
            }
            System.out.println();
        }
    }

    public char[] getABArray(int size, double probabilityOfA, Random random, Boolean changeInMiddle, double fraction) {
        int newSize = size + random.nextInt(size / 5);
        char[] a = new char[newSize];
        for (int i = 0; i < newSize; ++i) {
            double toss = changeInMiddle != false && ((double)i > (1.0 - fraction) * (double)newSize || (double)i < (double)newSize * fraction) ? 1.0 - probabilityOfA : probabilityOfA;
            a[i] = random.nextDouble() < toss ? 45 : 95;
        }
        return a;
    }

    double precision(int truePos, int falsePos) {
        return truePos + falsePos > 0 ? 1.0 * (double)truePos / (double)(truePos + falsePos) : 1.0;
    }

    double recall(int truePos, int falseNeg) {
        return truePos + falseNeg > 0 ? 1.0 * (double)truePos / (double)(truePos + falseNeg) : 1.0;
    }
}

