/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.event.LogEventBuilder;
import org.opensearch.dataprepper.model.log.Log;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.codec.json.NdjsonInputConfig;

@DataPrepperPlugin(name="ndjson", pluginType=InputCodec.class, pluginConfigurationType=NdjsonInputConfig.class)
public class NdjsonInputCodec
implements InputCodec {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final NdjsonInputConfig ndjsonInputConfig;
    private final EventFactory eventFactory;
    private final JsonFactory jsonFactory;

    @DataPrepperPluginConstructor
    public NdjsonInputCodec(NdjsonInputConfig ndjsonInputConfig, EventFactory eventFactory) {
        this.ndjsonInputConfig = ndjsonInputConfig;
        this.eventFactory = eventFactory;
        this.jsonFactory = new JsonFactory();
    }

    public void parse(InputStream inputStream, Consumer<Record<Event>> eventConsumer) throws IOException {
        Objects.requireNonNull(inputStream, "Parameter inputStream must not be null.");
        Objects.requireNonNull(eventConsumer, "Parameter eventConsumer must not be null.");
        JsonParser parser = this.jsonFactory.createParser(inputStream);
        JsonToken token = parser.nextToken();
        while (token != null) {
            if (token != JsonToken.START_ARRAY) {
                MappingIterator mapMappingIterator = this.objectMapper.readValues(parser, MAP_TYPE_REFERENCE);
                while (mapMappingIterator.hasNext()) {
                    Map json = (Map)mapMappingIterator.next();
                    if (!this.ndjsonInputConfig.isIncludeEmptyObjects() && json.isEmpty()) continue;
                    Record<Event> record = this.createRecord(json);
                    eventConsumer.accept(record);
                }
                break;
            }
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                Map json = (Map)this.objectMapper.readValue(parser, MAP_TYPE_REFERENCE);
                if (!this.ndjsonInputConfig.isIncludeEmptyObjects() && json.isEmpty()) continue;
                Record<Event> record = this.createRecord(json);
                eventConsumer.accept(record);
            }
            token = parser.nextToken();
        }
    }

    private Record<Event> createRecord(Map<String, Object> json) {
        Log event = (Log)((LogEventBuilder)this.eventFactory.eventBuilder(LogEventBuilder.class)).withData(json).build();
        return new Record((Object)event);
    }
}

