/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.export;

import com.mongodb.MongoClientException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.opensearch.dataprepper.model.source.coordinator.PartitionIdentifier;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.mongo.client.BsonHelper;
import org.opensearch.dataprepper.plugins.mongo.client.MongoDBConnection;
import org.opensearch.dataprepper.plugins.mongo.configuration.MongoDBSourceConfig;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.ExportPartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.state.ExportProgressState;
import org.opensearch.dataprepper.plugins.mongo.model.PartitionIdentifierBatch;
import org.opensearch.dataprepper.plugins.mongo.utils.DocumentDBSourceAggregateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBExportPartitionSupplier
implements Function<ExportPartition, PartitionIdentifierBatch> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBExportPartitionSupplier.class);
    private static final String MONGODB_PARTITION_KEY_FORMAT = "%s|%s|%s|%s|%s";
    private static final String COLLECTION_SPLITTER = "\\.";
    private final MongoDBSourceConfig sourceConfig;
    private final EnhancedSourceCoordinator enhancedSourceCoordinator;
    private final DocumentDBSourceAggregateMetrics documentDBAggregateMetrics;

    public MongoDBExportPartitionSupplier(MongoDBSourceConfig sourceConfig, EnhancedSourceCoordinator enhancedSourceCoordinator, DocumentDBSourceAggregateMetrics documentDBAggregateMetrics) {
        this.sourceConfig = sourceConfig;
        this.enhancedSourceCoordinator = enhancedSourceCoordinator;
        this.documentDBAggregateMetrics = documentDBAggregateMetrics;
    }

    private PartitionIdentifierBatch buildPartitions(ExportPartition exportPartition) {
        this.documentDBAggregateMetrics.getExportApiInvocations().increment();
        ArrayList<PartitionIdentifier> collectionPartitions = new ArrayList<PartitionIdentifier>();
        String collectionDbName = exportPartition.getCollection();
        List<String> collection = List.of(collectionDbName.split(COLLECTION_SPLITTER));
        if (collection.size() < 2) {
            this.documentDBAggregateMetrics.getExport4xxErrors().increment();
            throw new IllegalArgumentException("Invalid Collection Name. Must be in db.collection format");
        }
        Optional<ExportProgressState> exportProgressStateOptional = exportPartition.getProgressState();
        Object lastEndDocId = exportProgressStateOptional.map(ExportProgressState::getLastEndDocId).orElse(null);
        boolean isLastBatch = false;
        Object endDocId = lastEndDocId;
        try (MongoClient mongoClient = MongoDBConnection.getMongoClient(this.sourceConfig);){
            MongoDatabase db = mongoClient.getDatabase(collection.get(0));
            MongoCollection col = db.getCollection(collectionDbName.substring(collection.get(0).length() + 1));
            int partitionSize = exportPartition.getPartitionSize();
            FindIterable startIterable = lastEndDocId != null ? col.find(Filters.gt((String)"_id", lastEndDocId)).projection((Bson)new Document("_id", (Object)1)).sort((Bson)new Document("_id", (Object)1)).limit(1) : col.find().projection((Bson)new Document("_id", (Object)1)).sort((Bson)new Document("_id", (Object)1)).limit(1);
            while (!Thread.currentThread().isInterrupted()) {
                MongoCursor startCursor = startIterable.iterator();
                try {
                    if (!startCursor.hasNext()) {
                        LOG.info("No records to process or has reached end of the export partition.");
                        isLastBatch = true;
                    } else {
                        Document startDoc = (Document)startCursor.next();
                        Object gteValue = startDoc.get((Object)"_id");
                        String gteClassName = gteValue.getClass().getName();
                        Document endDoc = (Document)startIterable.skip(partitionSize - 1).limit(1).first();
                        if (endDoc == null) {
                            endDoc = (Document)col.find().projection((Bson)new Document("_id", (Object)1)).sort((Bson)new Document("_id", (Object)-1)).limit(1).first();
                            isLastBatch = true;
                        }
                        Object lteValue = endDoc.get((Object)"_id");
                        String lteClassName = lteValue.getClass().getName();
                        endDocId = lteValue;
                        String gteValueString = BsonHelper.getPartitionStringFromMongoDBId(gteValue, gteClassName);
                        String lteValueString = BsonHelper.getPartitionStringFromMongoDBId(lteValue, lteClassName);
                        LOG.debug("Partition of {} : { gte: {} class: {}, lte: {} class {} }", new Object[]{collectionDbName, gteValueString, gteClassName, lteValueString, lteClassName});
                        collectionPartitions.add(PartitionIdentifier.builder().withPartitionKey(String.format(MONGODB_PARTITION_KEY_FORMAT, collectionDbName, gteValueString, lteValueString, gteClassName, lteClassName)).build());
                        this.documentDBAggregateMetrics.getExportPartitionQueryCount().increment();
                        if (!isLastBatch) {
                            this.enhancedSourceCoordinator.saveProgressStateForPartition((EnhancedSourcePartition)exportPartition, null);
                            startIterable = col.find(BsonHelper.buildGtQuery(lteValueString, lteClassName, "MaxKey")).projection((Bson)new Document("_id", (Object)1)).sort((Bson)new Document("_id", (Object)1)).limit(1);
                            continue;
                        }
                    }
                    break;
                }
                finally {
                    if (startCursor == null) continue;
                    startCursor.close();
                }
            }
        }
        catch (MongoClientException | IllegalArgumentException e) {
            this.documentDBAggregateMetrics.getExport4xxErrors().increment();
            LOG.error("Client side exception while build partitions.", e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            this.documentDBAggregateMetrics.getExport5xxErrors().increment();
            LOG.error("Server side exception while build partitions.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return new PartitionIdentifierBatch(collectionPartitions, isLastBatch, endDocId);
    }

    @Override
    public PartitionIdentifierBatch apply(ExportPartition exportPartition) {
        return this.buildPartitions(exportPartition);
    }
}

