/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.service;

import com.arpnetworking.metrics.prometheus.Types;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.model.metric.ExponentialHistogram;
import org.opensearch.dataprepper.model.metric.Gauge;
import org.opensearch.dataprepper.model.metric.Histogram;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.metric.Quantile;
import org.opensearch.dataprepper.model.metric.Sum;
import org.opensearch.dataprepper.model.metric.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusTimeSeries {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusTimeSeries.class);
    private static final Character UNDERSCORE = Character.valueOf('_');
    private static final Map<String, String> otelToPrometheusUnitsMap = Map.ofEntries(Map.entry("d", "days"), Map.entry("h", "hours"), Map.entry("min", "minutes"), Map.entry("s", "seconds"), Map.entry("ms", "milliseconds"), Map.entry("us", "microseconds"), Map.entry("ns", "nanoseconds"), Map.entry("By", "bytes"), Map.entry("KiBy", "kibibytes"), Map.entry("MiBy", "mebibytes"), Map.entry("GiBy", "gibibytes"), Map.entry("TiBy", "tibibytes"), Map.entry("KBy", "kilobytes"), Map.entry("MBy", "megabytes"), Map.entry("GBy", "gigabytes"), Map.entry("TBy", "terabytes"), Map.entry("V", "volts"), Map.entry("A", "amperes"), Map.entry("J", "joules"), Map.entry("W", "watts"), Map.entry("g", "grams"), Map.entry("Cel", "celsius"), Map.entry("Hz", "hertz"), Map.entry("%", "percent"), Map.entry("m", "meters"));
    private final String metricName;
    private long timestamp;
    private boolean sanitizeNames;
    private List<Types.TimeSeries> timeSeriesList;
    private List<Types.Label> labels;
    private int size;

    public PrometheusTimeSeries(Metric metric, boolean sanitizeNames) throws Exception {
        this.sanitizeNames = sanitizeNames;
        this.metricName = sanitizeNames ? PrometheusTimeSeries.sanitizeMetricName(metric) : metric.getName();
        String time = metric.getTime();
        String startTime = metric.getStartTime();
        this.timestamp = time != null ? PrometheusTimeSeries.getTimeStampVal(time) : PrometheusTimeSeries.getTimeStampVal(startTime);
        this.timeSeriesList = new ArrayList<Types.TimeSeries>();
        this.labels = new ArrayList<Types.Label>();
        Map attributesMap = metric.getAttributes();
        Map<String, Object> flattenedAttributeMap = PrometheusTimeSeries.flattenMap(attributesMap);
        for (Map.Entry<String, Object> entry : flattenedAttributeMap.entrySet()) {
            this.addLabel(entry.getKey(), entry.getValue());
        }
        Map resourceAttributesMap = null;
        Map scopeAttributesMap = null;
        try {
            if (metric.getResource() != null) {
                resourceAttributesMap = (Map)metric.getResource().get("attributes");
            }
            if (metric.getScope() != null) {
                scopeAttributesMap = (Map)metric.getScope().get("attributes");
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get resource/scope attributes", (Throwable)e);
        }
        if (resourceAttributesMap != null) {
            flattenedAttributeMap = PrometheusTimeSeries.flattenMap(resourceAttributesMap);
            for (Map.Entry<String, Object> entry : flattenedAttributeMap.entrySet()) {
                this.addLabel("resource_" + entry.getKey(), entry.getValue());
            }
        }
        if (scopeAttributesMap != null) {
            flattenedAttributeMap = PrometheusTimeSeries.flattenMap(scopeAttributesMap);
            for (Map.Entry<String, Object> entry : flattenedAttributeMap.entrySet()) {
                this.addLabel("scope_" + entry.getKey(), entry.getValue());
            }
        }
    }

    private void addLabel(String name, Object value) {
        if (this.sanitizeNames) {
            name = PrometheusTimeSeries.sanitizeLabelName(name);
        }
        this.addLabelSanitized(name, value);
    }

    private void addLabelSanitized(String name, Object value) {
        String valueStr = value instanceof String ? (String)value : String.valueOf(value);
        Types.Label label = Types.Label.newBuilder().setName(name).setValue(valueStr).build();
        this.labels.add(label);
        this.size += label.toByteArray().length;
    }

    public List<Types.TimeSeries> getTimeSeriesList() {
        return this.timeSeriesList;
    }

    private void addTimeSeries(String labelName, String labelValue, Double sampleValue) {
        Types.Label label = Types.Label.newBuilder().setName(labelName).setValue(labelValue).build();
        this.size += label.toByteArray().length;
        Types.Sample sample = Types.Sample.newBuilder().setValue(sampleValue.doubleValue()).setTimestamp(this.timestamp).build();
        this.size += sample.toByteArray().length;
        this.timeSeriesList.add(Types.TimeSeries.newBuilder().addAllLabels(this.labels).addLabels(label).addSamples(sample).build());
    }

    private void addTimeSeries(String metricName, String labelName, String labelValue, Double sampleValue) {
        Types.Label label1 = Types.Label.newBuilder().setName("__name__").setValue(metricName).build();
        Types.Label label2 = Types.Label.newBuilder().setName(labelName).setValue(labelValue).build();
        this.size += label1.toByteArray().length + label2.toByteArray().length;
        Types.Sample sample = Types.Sample.newBuilder().setValue(sampleValue.doubleValue()).setTimestamp(this.timestamp).build();
        this.size += sample.toByteArray().length;
        this.timeSeriesList.add(Types.TimeSeries.newBuilder().addAllLabels(this.labels).addLabels(label1).addLabels(label2).addSamples(sample).build());
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public void addSumMetric(Sum sum) {
        this.addTimeSeries("__name__", this.metricName, sum.getValue());
    }

    public void addGaugeMetric(Gauge gauge) {
        this.addTimeSeries("__name__", this.metricName, gauge.getValue());
    }

    public void addSummaryMetric(Summary summary) {
        List quantiles = summary.getQuantiles();
        for (int i = 0; i < quantiles.size(); ++i) {
            Quantile quantile = (Quantile)quantiles.get(i);
            this.addTimeSeries(this.metricName, "quantile", quantile.getQuantile().toString(), (double)quantile.getValue());
        }
    }

    public void addHistogramMetric(Histogram histogram) {
        Double max;
        this.addTimeSeries("__name__", this.metricName + "_count", (double)histogram.getCount());
        this.addTimeSeries("__name__", this.metricName + "_sum", (double)histogram.getSum());
        Double min = histogram.getMin();
        if (min != null) {
            this.addTimeSeries("__name__", this.metricName + "_min", (double)min);
        }
        if ((max = histogram.getMax()) != null) {
            this.addTimeSeries("__name__", this.metricName + "_max", (double)max);
        }
        List explicitBounds = histogram.getExplicitBoundsList();
        List bucketCounts = histogram.getBucketCountsList();
        if (explicitBounds != null && bucketCounts != null) {
            this.addLabelSanitized("__name__", this.metricName + "_bucket");
            for (int i = 0; i < bucketCounts.size(); ++i) {
                String labelValue = i == bucketCounts.size() - 1 ? "+Inf" : ((Double)explicitBounds.get(i)).toString();
                this.addTimeSeries("le", labelValue, (double)((Long)bucketCounts.get(i)));
            }
        }
    }

    public void addExponentialHistogramMetric(ExponentialHistogram histogram) {
        boolean negativeBucketsPresent;
        Integer scale;
        Double zeroThreshold;
        this.addTimeSeries("__name__", this.metricName + "_count", (double)histogram.getCount());
        this.addTimeSeries("__name__", this.metricName + "_sum", (double)histogram.getSum());
        Long zeroCount = histogram.getZeroCount();
        if (zeroCount != null) {
            this.addTimeSeries("__name__", this.metricName + "_zero_count", (double)zeroCount);
        }
        if ((zeroThreshold = histogram.getZeroThreshold()) != null) {
            this.addTimeSeries("__name__", this.metricName + "_zero_threshold", (double)zeroThreshold);
        }
        if ((scale = histogram.getScale()) != null) {
            this.addTimeSeries("__name__", this.metricName + "_zero_threshold", (double)scale);
        }
        List positiveBucketCounts = histogram.getPositive();
        Integer positiveOffset = histogram.getPositiveOffset();
        List negativeBucketCounts = histogram.getNegative();
        Integer negativeOffset = histogram.getPositiveOffset();
        boolean positiveBucketsPresent = positiveBucketCounts != null && positiveOffset != null;
        boolean bl = negativeBucketsPresent = negativeBucketCounts != null && negativeOffset != null;
        if (positiveBucketsPresent || negativeBucketsPresent) {
            double bound;
            int i;
            this.addLabelSanitized("__name__", this.metricName + "_bucket");
            if (positiveBucketsPresent) {
                for (i = 0; i < positiveBucketCounts.size(); ++i) {
                    bound = this.calculateBucketBound(i + positiveOffset + 1, scale);
                    this.addTimeSeries("le", Double.toString(bound), (double)((Long)positiveBucketCounts.get(i)));
                }
            }
            if (negativeBucketsPresent) {
                for (i = 0; i < negativeBucketCounts.size(); ++i) {
                    bound = -1.0 * this.calculateBucketBound(i + negativeOffset + 1, scale);
                    this.addTimeSeries("ge", Double.toString(bound), (double)((Long)negativeBucketCounts.get(i)));
                }
            }
        }
    }

    private double calculateBucketBound(int index, int scale) {
        return Math.pow(2.0, (double)index * Math.pow(2.0, -scale));
    }

    private static void flattenHelper(Map<String, Object> map, String prefix, Map<String, Object> flatMap) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = prefix.isEmpty() ? entry.getKey() : prefix + "_" + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                PrometheusTimeSeries.flattenHelper((Map)value, key, flatMap);
                continue;
            }
            flatMap.put(key, value.toString());
        }
    }

    static String sanitizeMetricName(Metric metric) {
        String[] unitSplit;
        Object suffix;
        String name = metric.getName();
        String unit = metric.getUnit();
        boolean isGauge = metric.getKind().equals(Metric.KIND.GAUGE.toString());
        boolean isCounter = metric.getKind().equals(Metric.KIND.SUM.toString()) && ((Sum)metric).isMonotonic() && ((Sum)metric).getAggregationTemporality().equals("AGGREGATION_TEMPORALITY_CUMULATIVE");
        String metricName = PrometheusTimeSeries.sanitizeName(name, true, false);
        Object object = suffix = isCounter ? UNDERSCORE + "total" : "";
        if (unit.startsWith("{")) {
            return metricName + (String)suffix;
        }
        if (unit.equals("1") && isGauge) {
            return metricName + UNDERSCORE + "ratio";
        }
        String val = otelToPrometheusUnitsMap.get(unit);
        if (val != null) {
            return metricName + UNDERSCORE + val + (String)suffix;
        }
        if (unit.contains("/") && (unitSplit = unit.split("/")).length == 2) {
            String unit1 = otelToPrometheusUnitsMap.get(unitSplit[0]);
            String unit2 = otelToPrometheusUnitsMap.get(unitSplit[1]);
            if (unit1 != null && unit2 != null) {
                return metricName + UNDERSCORE + unit1 + UNDERSCORE + unit2 + (String)suffix;
            }
        }
        return unit.equals("1") ? metricName + (String)suffix : metricName + UNDERSCORE + unit + (String)suffix;
    }

    static String sanitizeLabelName(String name) {
        return PrometheusTimeSeries.sanitizeName(name, false, true);
    }

    static String sanitizeName(String name, boolean allowColon, boolean isLabel) {
        StringBuilder sb = new StringBuilder(name.length());
        Character prevChar = null;
        for (int i = 0; i < name.length(); ++i) {
            Character curChar = Character.valueOf(PrometheusTimeSeries.sanitizeChar(name.charAt(i), i == 0, allowColon));
            if (isLabel || curChar != UNDERSCORE || prevChar != UNDERSCORE) {
                sb.append(curChar);
            }
            prevChar = curChar;
        }
        return isLabel ? sb.toString() : StringUtils.stripEnd((String)StringUtils.stripStart((String)sb.toString(), (String)"_"), (String)"_");
    }

    private static char sanitizeChar(char c, boolean isFirst, boolean allowColon) {
        if (allowColon && c == ':') {
            return c;
        }
        if (isFirst) {
            return Character.isLetter(c) ? c : (char)'_';
        }
        return Character.isLetterOrDigit(c) ? c : (char)'_';
    }

    private static Map<String, Object> flattenMap(Map<String, Object> map) {
        HashMap<String, Object> flatMap = new HashMap<String, Object>();
        PrometheusTimeSeries.flattenHelper(map, "", flatMap);
        return flatMap;
    }

    private static long getTimeStampVal(String time) throws Exception {
        long timeStampVal = 0L;
        timeStampVal = Instant.parse(time).toEpochMilli();
        return timeStampVal;
    }

    public int getSize() {
        return this.size;
    }
}

