/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.service;

import com.arpnetworking.metrics.prometheus.Remote;
import com.arpnetworking.metrics.prometheus.Types;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.common.sink.DefaultSinkFlushResult;
import org.opensearch.dataprepper.common.sink.SinkBufferEntry;
import org.opensearch.dataprepper.common.sink.SinkFlushContext;
import org.opensearch.dataprepper.common.sink.SinkFlushResult;
import org.opensearch.dataprepper.common.sink.SinkFlushableBuffer;
import org.opensearch.dataprepper.common.sink.SinkMetrics;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.sink.prometheus.PrometheusHttpSender;
import org.opensearch.dataprepper.plugins.sink.prometheus.PrometheusPushResult;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkBufferEntry;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkFlushContext;

public class PrometheusSinkFlushableBuffer
implements SinkFlushableBuffer {
    List<SinkBufferEntry> buffer;
    final PrometheusSinkFlushContext sinkFlushContext;
    final SinkMetrics sinkMetrics;

    public PrometheusSinkFlushableBuffer(List<SinkBufferEntry> buffer, SinkMetrics sinkMetrics, SinkFlushContext sinkFlushContext) {
        this.buffer = buffer;
        this.sinkMetrics = sinkMetrics;
        this.sinkFlushContext = (PrometheusSinkFlushContext)sinkFlushContext;
    }

    public SinkFlushResult flush() {
        if (this.buffer.size() == 0) {
            return null;
        }
        PrometheusHttpSender httpSender = this.sinkFlushContext.getHttpSender();
        Remote.WriteRequest.Builder writeRequestBuilder = Remote.WriteRequest.newBuilder();
        ArrayList<Types.TimeSeries> allTimeSeries = new ArrayList<Types.TimeSeries>();
        ArrayList<Event> events = new ArrayList<Event>();
        for (SinkBufferEntry sinkBufferEntry : this.buffer) {
            PrometheusSinkBufferEntry bufferEntry = (PrometheusSinkBufferEntry)sinkBufferEntry;
            allTimeSeries.addAll(bufferEntry.getTimeSeries().getTimeSeriesList());
            events.add(bufferEntry.getEvent());
        }
        this.buffer.clear();
        writeRequestBuilder.addAllTimeseries(allTimeSeries);
        Remote.WriteRequest request = writeRequestBuilder.build();
        byte[] bytes = request.toByteArray();
        PrometheusPushResult result = httpSender.pushToEndpoint(bytes);
        if (!result.isSuccess()) {
            this.sinkMetrics.incrementRequestsFailedCounter(1);
            this.sinkMetrics.incrementEventsFailedCounter(events.size());
            return new DefaultSinkFlushResult(events, result.getStatusCode(), null);
        }
        this.sinkMetrics.incrementRequestsSuccessCounter(1);
        this.sinkMetrics.incrementEventsSuccessCounter(events.size());
        return null;
    }

    public List<Event> getEvents() {
        ArrayList<Event> result = new ArrayList<Event>();
        for (SinkBufferEntry bufferEntry : this.buffer) {
            result.add(bufferEntry.getEvent());
        }
        return result;
    }
}

