/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.service;

import org.opensearch.dataprepper.common.sink.SinkBufferEntry;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.metric.ExponentialHistogram;
import org.opensearch.dataprepper.model.metric.Gauge;
import org.opensearch.dataprepper.model.metric.Histogram;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.metric.Sum;
import org.opensearch.dataprepper.model.metric.Summary;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusTimeSeries;

public class PrometheusSinkBufferEntry
implements SinkBufferEntry {
    final Event event;
    final PrometheusTimeSeries timeSeries;

    public PrometheusSinkBufferEntry(Event event, boolean sanitizeNames) throws Exception {
        this.event = event;
        this.timeSeries = this.getTimeSeriesForEvent(sanitizeNames);
    }

    public PrometheusTimeSeries getTimeSeries() {
        return this.timeSeries;
    }

    public long getEstimatedSize() {
        return this.timeSeries.getSize();
    }

    public boolean exceedsMaxEventSizeThreshold() {
        return false;
    }

    public Event getEvent() {
        return this.event;
    }

    private PrometheusTimeSeries getTimeSeriesForEvent(boolean sanitizeNames) throws Exception {
        if (this.event.getMetadata().getEventType().equals(EventType.METRIC.toString())) {
            PrometheusTimeSeries timeSeries = new PrometheusTimeSeries((Metric)this.event, sanitizeNames);
            if (this.event instanceof Gauge) {
                Gauge gauge = (Gauge)this.event;
                timeSeries.addGaugeMetric(gauge);
            } else if (this.event instanceof Sum) {
                Sum sum = (Sum)this.event;
                timeSeries.addSumMetric(sum);
            } else if (this.event instanceof Summary) {
                Summary summary = (Summary)this.event;
                timeSeries.addSummaryMetric(summary);
            } else if (this.event instanceof Histogram) {
                Histogram histogram = (Histogram)this.event;
                timeSeries.addHistogramMetric(histogram);
            } else if (this.event instanceof ExponentialHistogram) {
                ExponentialHistogram exponentialHistogram = (ExponentialHistogram)this.event;
                timeSeries.addExponentialHistogramMetric(exponentialHistogram);
            } else {
                throw new RuntimeException("Unknown metric type");
            }
            return timeSeries;
        }
        throw new RuntimeException("Not metric type");
    }
}

