/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum AuthTypeOptions {
    HTTP_BASIC("http_basic"),
    BEARER_TOKEN("bearer_token"),
    UNAUTHENTICATED("unauthenticated");

    private static final Map<String, AuthTypeOptions> OPTIONS_MAP;
    private final String option;

    private AuthTypeOptions(String option) {
        this.option = option;
    }

    @JsonCreator
    static AuthTypeOptions fromOptionValue(String option) {
        return OPTIONS_MAP.get(option);
    }

    static {
        OPTIONS_MAP = Arrays.stream(AuthTypeOptions.values()).collect(Collectors.toMap(value -> value.option, value -> value));
    }
}

