/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.sqs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.accumulator.Buffer;

public class SqsSinkBatchEntry {
    private final List<EventHandle> eventHandles = new ArrayList<EventHandle>();
    private final String groupId;
    private final String deDupId;
    private final Buffer buffer;
    private final OutputCodec codec;
    private final OutputCodecContext codecContext;
    private OutputCodec.Writer writer;
    private int eventCount;
    private int size;
    private boolean completed;

    public SqsSinkBatchEntry(Buffer buffer, String groupId, String deDupId, OutputCodec codec, OutputCodecContext codecContext) {
        this.buffer = buffer;
        this.completed = false;
        this.groupId = groupId;
        this.deDupId = deDupId;
        this.codec = codec;
        this.codecContext = codecContext;
        this.eventCount = 0;
        this.size = 0;
    }

    public String getBody() {
        return this.buffer.getOutputStream().toString();
    }

    public void releaseEventHandles(boolean result) {
        for (EventHandle eventHandle : this.eventHandles) {
            eventHandle.release(result);
        }
    }

    public void addEvent(Event event) throws Exception {
        if (this.completed) {
            throw new RuntimeException("Batch is completed");
        }
        if (this.eventCount == 0) {
            this.writer = this.codec.createWriter(this.buffer.getOutputStream(), null, this.codecContext);
        }
        this.writer.writeEvent(event);
        this.eventHandles.add(event.getEventHandle());
        ++this.eventCount;
    }

    public long getSize() {
        return this.buffer.getSize();
    }

    public void complete() throws IOException {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.writer.complete();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDedupId() {
        return this.deDupId;
    }

    public List<EventHandle> getEventHandles() {
        return this.eventHandles;
    }

    public int getEventCount() {
        return this.eventCount;
    }
}

