/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.stream;

import org.opensearch.dataprepper.plugins.source.rds.model.BinlogCoordinate;
import org.postgresql.replication.LogSequenceNumber;

public class ChangeEventStatus {
    private final BinlogCoordinate binlogCoordinate;
    private final LogSequenceNumber logSequenceNumber;
    private final long timestamp;
    private final long recordCount;
    private volatile AcknowledgmentStatus acknowledgmentStatus;

    public ChangeEventStatus(BinlogCoordinate binlogCoordinate, long timestamp, long recordCount) {
        this.binlogCoordinate = binlogCoordinate;
        this.logSequenceNumber = null;
        this.timestamp = timestamp;
        this.recordCount = recordCount;
        this.acknowledgmentStatus = AcknowledgmentStatus.NO_ACK;
    }

    public ChangeEventStatus(LogSequenceNumber logSequenceNumber, long timestamp, long recordCount) {
        this.binlogCoordinate = null;
        this.logSequenceNumber = logSequenceNumber;
        this.timestamp = timestamp;
        this.recordCount = recordCount;
        this.acknowledgmentStatus = AcknowledgmentStatus.NO_ACK;
    }

    public void setAcknowledgmentStatus(AcknowledgmentStatus acknowledgmentStatus) {
        this.acknowledgmentStatus = acknowledgmentStatus;
    }

    public AcknowledgmentStatus getAcknowledgmentStatus() {
        return this.acknowledgmentStatus;
    }

    public boolean isPositiveAcknowledgment() {
        return this.acknowledgmentStatus == AcknowledgmentStatus.POSITIVE_ACK;
    }

    public boolean isNegativeAcknowledgment() {
        return this.acknowledgmentStatus == AcknowledgmentStatus.NEGATIVE_ACK;
    }

    public BinlogCoordinate getBinlogCoordinate() {
        return this.binlogCoordinate;
    }

    public LogSequenceNumber getLogSequenceNumber() {
        return this.logSequenceNumber;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public static enum AcknowledgmentStatus {
        POSITIVE_ACK,
        NEGATIVE_ACK,
        NO_ACK;

    }
}

