/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.export;

import java.util.Collection;
import java.util.UUID;
import org.opensearch.dataprepper.plugins.source.rds.utils.RdsSourceAggregateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.rds.model.ExportTask;
import software.amazon.awssdk.services.rds.model.StartExportTaskRequest;
import software.amazon.awssdk.services.rds.model.StartExportTaskResponse;

public class ExportTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExportTaskManager.class);
    private static final int EXPORT_TASK_ID_MAX_LENGTH = 60;
    private final RdsClient rdsClient;
    private final RdsSourceAggregateMetrics rdsSourceAggregateMetrics;

    public ExportTaskManager(RdsClient rdsClient, RdsSourceAggregateMetrics rdsSourceAggregateMetrics) {
        this.rdsClient = rdsClient;
        this.rdsSourceAggregateMetrics = rdsSourceAggregateMetrics;
    }

    public String startExportTask(String snapshotArn, String iamRoleArn, String bucket, String prefix, String kmsKeyId, Collection<String> includeTables) {
        String exportTaskId = this.generateExportTaskId(snapshotArn);
        StartExportTaskRequest.Builder requestBuilder = StartExportTaskRequest.builder().exportTaskIdentifier(exportTaskId).sourceArn(snapshotArn).iamRoleArn(iamRoleArn).s3BucketName(bucket).s3Prefix(prefix).kmsKeyId(kmsKeyId);
        if (includeTables != null && !includeTables.isEmpty()) {
            requestBuilder.exportOnly(includeTables);
        }
        try {
            this.rdsSourceAggregateMetrics.getExportApiInvocations().increment();
            StartExportTaskResponse response = this.rdsClient.startExportTask((StartExportTaskRequest)requestBuilder.build());
            LOG.info("Export task submitted with id {} and status {}", (Object)exportTaskId, (Object)response.status());
            return exportTaskId;
        }
        catch (SdkException e) {
            this.rdsSourceAggregateMetrics.getExport4xxErrors().increment();
            LOG.error("Failed to start an export task with error: {}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            this.rdsSourceAggregateMetrics.getExport5xxErrors().increment();
            LOG.error("Failed to start an export task with error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public String checkExportStatus(String exportTaskId) {
        DescribeExportTasksRequest request = (DescribeExportTasksRequest)DescribeExportTasksRequest.builder().exportTaskIdentifier(exportTaskId).build();
        DescribeExportTasksResponse response = this.rdsClient.describeExportTasks(request);
        return ((ExportTask)response.exportTasks().get(0)).status();
    }

    private String generateExportTaskId(String snapshotArn) {
        String snapshotId = Arn.fromString((String)snapshotArn).resource().resource();
        String truncatedSnapshotId = this.truncateString(snapshotId, 44);
        truncatedSnapshotId = truncatedSnapshotId.replaceAll("-+$", "");
        return truncatedSnapshotId + "-export-" + UUID.randomUUID().toString().substring(0, 8);
    }

    private String truncateString(String originalString, int maxLength) {
        if (originalString.length() <= maxLength) {
            return originalString;
        }
        return originalString.substring(0, maxLength);
    }
}

