/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.coordination.partition;

import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.state.DataFileProgressState;

public class DataFilePartition
extends EnhancedSourcePartition<DataFileProgressState> {
    public static final String PARTITION_TYPE = "DATAFILE";
    private final String exportTaskId;
    private final String bucket;
    private final String key;
    private final DataFileProgressState state;

    public DataFilePartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        String[] keySplits = sourcePartitionStoreItem.getSourcePartitionKey().split("\\|");
        this.exportTaskId = keySplits[0];
        this.bucket = keySplits[1];
        this.key = keySplits[2];
        this.state = (DataFileProgressState)this.convertStringToPartitionProgressState(DataFileProgressState.class, sourcePartitionStoreItem.getPartitionProgressState());
    }

    public DataFilePartition(String exportTaskId, String bucket, String key, Optional<DataFileProgressState> state) {
        this.exportTaskId = exportTaskId;
        this.bucket = bucket;
        this.key = key;
        this.state = state.orElse(null);
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return this.exportTaskId + "|" + this.bucket + "|" + this.key;
    }

    public Optional<DataFileProgressState> getProgressState() {
        if (this.state != null) {
            return Optional.of(this.state);
        }
        return Optional.empty();
    }

    public String getExportTaskId() {
        return this.exportTaskId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }
}

