/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.coordination;

import java.util.function.Function;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.DataFilePartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.ExportPartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.GlobalState;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.LeaderPartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.ResyncPartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.StreamPartition;

public class PartitionFactory
implements Function<SourcePartitionStoreItem, EnhancedSourcePartition> {
    @Override
    public EnhancedSourcePartition apply(SourcePartitionStoreItem partitionStoreItem) {
        String partitionType;
        String sourceIdentifier = partitionStoreItem.getSourceIdentifier();
        switch (partitionType = sourceIdentifier.substring(sourceIdentifier.lastIndexOf(124) + 1)) {
            case "LEADER": {
                return new LeaderPartition(partitionStoreItem);
            }
            case "EXPORT": {
                return new ExportPartition(partitionStoreItem);
            }
            case "DATAFILE": {
                return new DataFilePartition(partitionStoreItem);
            }
            case "STREAM": {
                return new StreamPartition(partitionStoreItem);
            }
            case "RESYNC": {
                return new ResyncPartition(partitionStoreItem);
            }
        }
        return new GlobalState(partitionStoreItem);
    }
}

