/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds;

import com.github.shyiko.mysql.binlog.network.SSLMode;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.plugins.source.rds.ClientFactory;
import org.opensearch.dataprepper.plugins.source.rds.RdsSourceConfig;
import org.opensearch.dataprepper.plugins.source.rds.export.DataFileScheduler;
import org.opensearch.dataprepper.plugins.source.rds.export.ExportScheduler;
import org.opensearch.dataprepper.plugins.source.rds.export.ExportTaskManager;
import org.opensearch.dataprepper.plugins.source.rds.export.SnapshotManager;
import org.opensearch.dataprepper.plugins.source.rds.leader.ClusterApiStrategy;
import org.opensearch.dataprepper.plugins.source.rds.leader.InstanceApiStrategy;
import org.opensearch.dataprepper.plugins.source.rds.leader.LeaderScheduler;
import org.opensearch.dataprepper.plugins.source.rds.leader.RdsApiStrategy;
import org.opensearch.dataprepper.plugins.source.rds.model.DbMetadata;
import org.opensearch.dataprepper.plugins.source.rds.model.DbTableMetadata;
import org.opensearch.dataprepper.plugins.source.rds.resync.ResyncScheduler;
import org.opensearch.dataprepper.plugins.source.rds.schema.ConnectionManager;
import org.opensearch.dataprepper.plugins.source.rds.schema.ConnectionManagerFactory;
import org.opensearch.dataprepper.plugins.source.rds.schema.MySqlConnectionManager;
import org.opensearch.dataprepper.plugins.source.rds.schema.QueryManager;
import org.opensearch.dataprepper.plugins.source.rds.schema.SchemaManager;
import org.opensearch.dataprepper.plugins.source.rds.schema.SchemaManagerFactory;
import org.opensearch.dataprepper.plugins.source.rds.stream.ReplicationLogClientFactory;
import org.opensearch.dataprepper.plugins.source.rds.stream.StreamScheduler;
import org.opensearch.dataprepper.plugins.source.rds.utils.IdentifierShortener;
import org.opensearch.dataprepper.plugins.source.rds.utils.RdsSourceAggregateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.s3.S3Client;

public class RdsService {
    private static final Logger LOG = LoggerFactory.getLogger(RdsService.class);
    public static final int DATA_LOADER_MAX_JOB_COUNT = 1;
    public static final String S3_PATH_DELIMITER = "/";
    public static final int MAX_SOURCE_IDENTIFIER_LENGTH = 15;
    private final RdsClient rdsClient;
    private final S3Client s3Client;
    private final EnhancedSourceCoordinator sourceCoordinator;
    private final EventFactory eventFactory;
    private final PluginMetrics pluginMetrics;
    private final RdsSourceConfig sourceConfig;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final PluginConfigObservable pluginConfigObservable;
    private final RdsSourceAggregateMetrics rdsSourceAggregateMetrics;
    private final PipelineDescription pipelineDescription;
    private ExecutorService executor;
    private LeaderScheduler leaderScheduler;
    private ExportScheduler exportScheduler;
    private DataFileScheduler dataFileScheduler;
    private StreamScheduler streamScheduler;
    private ResyncScheduler resyncScheduler;

    public RdsService(EnhancedSourceCoordinator sourceCoordinator, RdsSourceConfig sourceConfig, EventFactory eventFactory, ClientFactory clientFactory, PluginMetrics pluginMetrics, AcknowledgementSetManager acknowledgementSetManager, PluginConfigObservable pluginConfigObservable, PipelineDescription pipelineDescription) {
        this.sourceCoordinator = sourceCoordinator;
        this.eventFactory = eventFactory;
        this.pluginMetrics = pluginMetrics;
        this.sourceConfig = sourceConfig;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.pluginConfigObservable = pluginConfigObservable;
        this.rdsSourceAggregateMetrics = new RdsSourceAggregateMetrics();
        this.pipelineDescription = pipelineDescription;
        this.rdsClient = clientFactory.buildRdsClient();
        this.s3Client = clientFactory.buildS3Client();
    }

    public void start(Buffer<Record<Event>> buffer) {
        LOG.info("Start running RDS service");
        ArrayList<Runnable> runnableList = new ArrayList<Runnable>();
        RdsApiStrategy rdsApiStrategy = this.sourceConfig.isCluster() ? new ClusterApiStrategy(this.rdsClient) : new InstanceApiStrategy(this.rdsClient);
        DbMetadata dbMetadata = rdsApiStrategy.describeDb(this.sourceConfig.getDbIdentifier());
        String s3PathPrefix = this.getS3PathPrefix();
        SchemaManager schemaManager = this.getSchemaManager(this.sourceConfig, dbMetadata);
        DbTableMetadata dbTableMetadata = this.getDbTableMetadata(dbMetadata, schemaManager);
        this.leaderScheduler = new LeaderScheduler(this.sourceCoordinator, this.sourceConfig, s3PathPrefix, schemaManager, dbTableMetadata, this.pipelineDescription.getPipelineName());
        runnableList.add(this.leaderScheduler);
        if (this.sourceConfig.isExportEnabled()) {
            SnapshotManager snapshotManager = new SnapshotManager(rdsApiStrategy);
            ExportTaskManager exportTaskManager = new ExportTaskManager(this.rdsClient, this.rdsSourceAggregateMetrics);
            this.exportScheduler = new ExportScheduler(this.sourceCoordinator, snapshotManager, exportTaskManager, this.s3Client, this.pluginMetrics);
            this.dataFileScheduler = new DataFileScheduler(this.sourceCoordinator, this.sourceConfig, s3PathPrefix, this.s3Client, this.eventFactory, buffer, this.pluginMetrics, this.acknowledgementSetManager);
            runnableList.add(this.exportScheduler);
            runnableList.add(this.dataFileScheduler);
        }
        if (this.sourceConfig.isStreamEnabled()) {
            ReplicationLogClientFactory replicationLogClientFactory = new ReplicationLogClientFactory(this.sourceConfig, this.rdsClient, dbMetadata, this.rdsSourceAggregateMetrics);
            if (this.sourceConfig.isTlsEnabled()) {
                replicationLogClientFactory.setSSLMode(SSLMode.REQUIRED);
            } else {
                replicationLogClientFactory.setSSLMode(SSLMode.DISABLED);
            }
            this.streamScheduler = new StreamScheduler(this.sourceCoordinator, this.sourceConfig, s3PathPrefix, replicationLogClientFactory, buffer, this.pluginMetrics, this.acknowledgementSetManager, this.pluginConfigObservable);
            runnableList.add(this.streamScheduler);
            if (this.sourceConfig.getEngine().isMySql()) {
                this.resyncScheduler = new ResyncScheduler(this.sourceCoordinator, this.sourceConfig, this.getQueryManager(this.sourceConfig, dbMetadata), s3PathPrefix, buffer, this.pluginMetrics, this.acknowledgementSetManager);
                runnableList.add(this.resyncScheduler);
            }
        }
        this.executor = Executors.newFixedThreadPool(runnableList.size());
        runnableList.forEach(this.executor::submit);
    }

    public void shutdown() {
        if (this.executor != null) {
            LOG.info("shutdown RDS schedulers");
            if (this.sourceConfig.isExportEnabled()) {
                this.exportScheduler.shutdown();
                this.dataFileScheduler.shutdown();
            }
            if (this.sourceConfig.isStreamEnabled()) {
                this.streamScheduler.shutdown();
            }
            this.leaderScheduler.shutdown();
            this.executor.shutdownNow();
        }
    }

    SchemaManager getSchemaManager(RdsSourceConfig sourceConfig, DbMetadata dbMetadata) {
        ConnectionManager connectionManager = new ConnectionManagerFactory(sourceConfig, dbMetadata).getConnectionManager();
        return new SchemaManagerFactory(connectionManager).getSchemaManager();
    }

    private QueryManager getQueryManager(RdsSourceConfig sourceConfig, DbMetadata dbMetadata) {
        String readerEndpoint = dbMetadata.getReaderEndpoint() != null ? dbMetadata.getReaderEndpoint() : dbMetadata.getEndpoint();
        int readerPort = dbMetadata.getReaderPort() == 0 ? dbMetadata.getPort() : dbMetadata.getReaderPort();
        MySqlConnectionManager readerConnectionManager = new MySqlConnectionManager(readerEndpoint, readerPort, sourceConfig.getAuthenticationConfig().getUsername(), sourceConfig.getAuthenticationConfig().getPassword(), sourceConfig.isTlsEnabled());
        return new QueryManager(readerConnectionManager);
    }

    private String getS3PathPrefix() {
        String s3PathPrefix;
        String s3UserPathPrefix = this.sourceConfig.getS3Prefix() != null && !this.sourceConfig.getS3Prefix().isBlank() ? this.sourceConfig.getS3Prefix() : "";
        if (this.sourceCoordinator.getPartitionPrefix() != null) {
            String uniqueIdentifier = IdentifierShortener.shortenIdentifier(this.sourceCoordinator.getPartitionPrefix(), 15);
            s3PathPrefix = s3UserPathPrefix.isEmpty() ? uniqueIdentifier : s3UserPathPrefix + S3_PATH_DELIMITER + uniqueIdentifier;
            LOG.info("Unique identifier used in S3 path prefix is {}", (Object)uniqueIdentifier);
        } else {
            s3PathPrefix = s3UserPathPrefix;
        }
        return s3PathPrefix;
    }

    private DbTableMetadata getDbTableMetadata(DbMetadata dbMetadata, SchemaManager schemaManager) {
        Map<String, Map<String, String>> tableColumnDataTypeMap = this.getColumnDataTypeMap(schemaManager);
        return new DbTableMetadata(dbMetadata, tableColumnDataTypeMap);
    }

    private Map<String, Map<String, String>> getColumnDataTypeMap(SchemaManager schemaManager) {
        Set<String> tableNames = schemaManager.getTableNames(this.sourceConfig.getDatabase());
        this.sourceConfig.applyTableFilter(tableNames);
        LOG.info("These tables will be included in processing: {}", tableNames);
        return schemaManager.getColumnDataTypes(new ArrayList<String>(tableNames));
    }
}

