/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.summarization;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.returntypes.SampleSummary;
import com.amazon.randomcutforest.summarization.Center;
import com.amazon.randomcutforest.summarization.GenericMultiCenter;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.summarization.MultiCenter;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Summarizer {
    public static double WEIGHT_ALLOCATION_THRESHOLD = 1.25;
    public static double DEFAULT_SEPARATION_RATIO_FOR_MERGE = 0.8;
    public static int PHASE2_THRESHOLD = 2;
    public static int LENGTH_BOUND = 1000;

    public static Double L1distance(float[] a, float[] b) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            dist += (double)Math.abs(a[i] - b[i]);
        }
        return dist;
    }

    public static Double L2distance(float[] a, float[] b) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double t = Math.abs(a[i] - b[i]);
            dist += t * t;
        }
        return Math.sqrt(dist);
    }

    public static Double LInfinitydistance(float[] a, float[] b) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            dist = Math.max((double)Math.abs(a[i] - b[i]), dist);
        }
        return dist;
    }

    public static <R> void assignAndRecompute(List<Weighted<Integer>> sampledPoints, Function<Integer, R> getPoint, List<ICluster<R>> clusters, BiFunction<R, R, Double> distance, boolean parallelEnabled) {
        CommonUtils.checkArgument(clusters.size() > 0, " cannot be empty list of clusters");
        CommonUtils.checkArgument(sampledPoints.size() > 0, " cannot be empty list of points");
        for (ICluster<R> iCluster : clusters) {
            iCluster.reset();
        }
        for (Weighted weighted : sampledPoints) {
            int i;
            if (!(weighted.weight > 0.0f)) continue;
            double[] dist = new double[clusters.size()];
            Arrays.fill(dist, Double.MAX_VALUE);
            double minDist = Double.MAX_VALUE;
            int minDistNbr = -1;
            for (int i2 = 0; i2 < clusters.size(); ++i2) {
                dist[i2] = clusters.get(i2).distance(getPoint.apply((Integer)weighted.index), distance);
                if (minDist > dist[i2]) {
                    minDist = dist[i2];
                    minDistNbr = i2;
                }
                if (minDist == 0.0) break;
            }
            if (minDist == 0.0) {
                clusters.get(minDistNbr).addPoint((Integer)weighted.index, weighted.weight, 0.0, getPoint.apply((Integer)weighted.index), distance);
                continue;
            }
            double sum = 0.0;
            for (i = 0; i < clusters.size(); ++i) {
                if (!(dist[i] <= WEIGHT_ALLOCATION_THRESHOLD * minDist)) continue;
                sum += minDist / dist[i];
            }
            for (i = 0; i < clusters.size(); ++i) {
                if (!(dist[i] <= WEIGHT_ALLOCATION_THRESHOLD * minDist)) continue;
                clusters.get(i).addPoint((Integer)weighted.index, (float)((double)weighted.weight * minDist / (dist[i] * sum)), dist[i], getPoint.apply((Integer)weighted.index), distance);
            }
        }
        if (parallelEnabled) {
            clusters.parallelStream().forEach(e -> e.recompute(getPoint, true, distance));
        } else {
            clusters.stream().forEach(e -> e.recompute(getPoint, true, distance));
        }
    }

    public static <R> List<ICluster<R>> iterativeClustering(int maxAllowed, int initial, int stopAt, List<Weighted<Integer>> refs, Function<Integer, R> getPoint, BiFunction<R, R, Double> distance, BiFunction<R, Float, ICluster<R>> clusterInitializer, long seed, boolean parallelEnabled, boolean phase2GlobalReassign, double overlapParameter, List<ICluster<R>> previousClustering) {
        boolean keepReducingCenters;
        CommonUtils.checkArgument(refs.size() > 0, "empty list, nothing to do");
        CommonUtils.checkArgument(stopAt > 0, "has to stop at 1 cluster");
        CommonUtils.checkArgument(stopAt <= maxAllowed, "cannot stop before achieving the limit");
        Random rng = new Random(seed);
        double sampledSum = refs.stream().map(e -> {
            CommonUtils.checkArgument(Double.isFinite(e.weight), " weights have to be finite");
            CommonUtils.checkArgument((double)e.weight >= 0.0, () -> "negative weights are not meaningful" + e.weight);
            return e.weight;
        }).reduce(0.0, Double::sum);
        CommonUtils.checkArgument(sampledSum > 0.0, " total weight has to be positive");
        ArrayList<ICluster<R>> centers = new ArrayList<ICluster<R>>();
        if (refs.size() < 10 * (initial + 5)) {
            for (Weighted<Integer> point : refs) {
                centers.add(clusterInitializer.apply(getPoint.apply((Integer)point.index), Float.valueOf(0.0f)));
            }
        } else {
            for (int k = 0; k < 2 * (initial + 5); ++k) {
                double wt = rng.nextDouble() * sampledSum;
                Weighted picked = Weighted.prefixPick(refs, wt);
                centers.add(clusterInitializer.apply(getPoint.apply((Integer)picked.index), Float.valueOf(0.0f)));
            }
        }
        if (previousClustering != null) {
            for (ICluster<R> previousCluster : previousClustering) {
                List<Weighted<R>> representatives = previousCluster.getRepresentatives();
                for (Weighted<R> representative : representatives) {
                    centers.add(clusterInitializer.apply(representative.index, Float.valueOf(0.0f)));
                }
            }
        }
        Summarizer.assignAndRecompute(refs, getPoint, centers, distance, parallelEnabled);
        centers.sort(Comparator.comparingDouble(ICluster::getWeight));
        while (centers.get(0).getWeight() == 0.0) {
            centers.remove(0);
        }
        double phase3Distance = 0.0;
        double runningPhase3Distance = 0.0;
        boolean bl = keepReducingCenters = centers.size() > maxAllowed;
        while (keepReducingCenters) {
            int lower;
            double measure = 0.0;
            double measureDist = Double.MAX_VALUE;
            int firstOfMerge = lower = 0;
            int secondOfMerge = lower + 1;
            boolean foundMerge = false;
            double minDist = Double.MAX_VALUE;
            while (lower < centers.size() - 1 && !foundMerge) {
                int minNbr = -1;
                for (int j = lower + 1; j < centers.size(); ++j) {
                    double temp;
                    double dist = centers.get(lower).distance(centers.get(j), distance);
                    if (dist == 0.0) {
                        foundMerge = true;
                        firstOfMerge = lower;
                        secondOfMerge = minNbr = j;
                        measureDist = 0.0;
                        minDist = 0.0;
                        break;
                    }
                    if (minDist > dist) {
                        minNbr = j;
                        minDist = dist;
                    }
                    if (!((temp = (centers.get(lower).extentMeasure() + centers.get(j).extentMeasure() + phase3Distance) / dist) > overlapParameter) || !(measure < temp)) continue;
                    firstOfMerge = lower;
                    secondOfMerge = j;
                    measure = temp;
                    measureDist = dist;
                }
                if (lower == 0 && !foundMerge) {
                    measureDist = minDist;
                    secondOfMerge = minNbr;
                }
                ++lower;
            }
            int inital = centers.size();
            if (inital > maxAllowed || foundMerge || inital > stopAt && measure > overlapParameter) {
                centers.get(secondOfMerge).absorb(centers.get(firstOfMerge), distance);
                if (phase2GlobalReassign && centers.size() <= PHASE2_THRESHOLD * maxAllowed + 1) {
                    centers.remove(firstOfMerge);
                    Summarizer.assignAndRecompute(refs, getPoint, centers, distance, parallelEnabled);
                } else {
                    centers.get(secondOfMerge).recompute(getPoint, false, distance);
                    centers.remove(firstOfMerge);
                }
                centers.sort(Comparator.comparingDouble(ICluster::getWeight));
                while (centers.get(0).getWeight() == 0.0) {
                    centers.remove(0);
                }
                if (!((double)inital < 1.2 * (double)maxAllowed + 1.0)) continue;
                runningPhase3Distance = Math.max(runningPhase3Distance, measureDist);
                if (inital <= maxAllowed || centers.size() > maxAllowed) continue;
                phase3Distance = runningPhase3Distance;
                continue;
            }
            keepReducingCenters = false;
        }
        centers.sort((o1, o2) -> Double.compare(o2.getWeight(), o1.getWeight()));
        return centers;
    }

    public static <R> List<ICluster<R>> summarize(List<Weighted<R>> points, int maxAllowed, int initial, int stopAt, boolean phase2GlobalReassign, double overlapParameter, BiFunction<R, R, Double> distance, BiFunction<R, Float, ICluster<R>> clusterInitializer, long seed, boolean parallelEnabled, List<ICluster<R>> previousClustering) {
        CommonUtils.checkArgument(maxAllowed < 100, "are you sure you want more elements in the summary?");
        CommonUtils.checkArgument(maxAllowed <= initial, "initial parameter should be at least maximum allowed in final result");
        double totalWeight = points.stream().map(e -> {
            CommonUtils.checkArgument(Double.isFinite(e.weight), " weights have to be finite");
            CommonUtils.checkArgument((double)e.weight >= 0.0, () -> "negative weights are not meaningful" + e.weight);
            return e.weight;
        }).reduce(0.0, Double::sum);
        CommonUtils.checkArgument(totalWeight > 0.0, " total weight has to be positive");
        Random rng = new Random(seed);
        List sampledPoints = Weighted.createSample(points, rng.nextLong(), 5 * LENGTH_BOUND, 0.005, 1.0);
        ArrayList<Weighted<Integer>> refs = new ArrayList<Weighted<Integer>>();
        for (int i2 = 0; i2 < sampledPoints.size(); ++i2) {
            refs.add(new Weighted<Integer>(i2, sampledPoints.get((int)i2).weight));
        }
        Function<Integer, Object> getPoint = i -> ((Weighted)sampledPoints.get((int)i.intValue())).index;
        return Summarizer.iterativeClustering(maxAllowed, initial, stopAt, refs, getPoint, distance, clusterInitializer, rng.nextLong(), parallelEnabled, phase2GlobalReassign, overlapParameter, previousClustering);
    }

    public static List<ICluster<float[]>> singleCentroidSummarize(List<Weighted<float[]>> points, int maxAllowed, int initial, int stopAt, boolean phase2GlobalReassign, BiFunction<float[], float[], Double> distance, long seed, boolean parallelEnabled, List<ICluster<float[]>> previousClustering) {
        return Summarizer.summarize(points, maxAllowed, initial, stopAt, phase2GlobalReassign, DEFAULT_SEPARATION_RATIO_FOR_MERGE, distance, Center::initialize, seed, parallelEnabled, previousClustering);
    }

    public static SampleSummary summarize(List<Weighted<float[]>> points, int maxAllowed, int initial, boolean phase1reassign, BiFunction<float[], float[], Double> distance, long seed, boolean parallelEnabled) {
        CommonUtils.checkArgument(maxAllowed < 100, "are you sure you want more elements in the summary?");
        CommonUtils.checkArgument(maxAllowed <= initial, "initial parameter should be at least maximum allowed in final result");
        double totalWeight = points.stream().map(e -> {
            CommonUtils.checkArgument(Double.isFinite(e.weight), " weights have to be finite");
            CommonUtils.checkArgument((double)e.weight >= 0.0, () -> "negative weights are not meaningful" + e.weight);
            return e.weight;
        }).reduce(0.0, Double::sum);
        CommonUtils.checkArgument(totalWeight > 0.0, " total weight has to be positive");
        Random rng = new Random(seed);
        List<Weighted<float[]>> sampledPoints = Weighted.createSample(points, rng.nextLong(), 5 * LENGTH_BOUND, 0.005, 1.0);
        List<ICluster<float[]>> centers = Summarizer.summarize(sampledPoints, maxAllowed, initial, 1, true, DEFAULT_SEPARATION_RATIO_FOR_MERGE, distance, Center::initialize, seed, parallelEnabled, null);
        float[][] pointList = new float[centers.size()][];
        float[] likelihood = new float[centers.size()];
        int dimensions = centers.get(0).primaryRepresentative(distance).length;
        for (int i = 0; i < centers.size(); ++i) {
            pointList[i] = Arrays.copyOf(centers.get(i).primaryRepresentative(distance), dimensions);
            likelihood[i] = (float)(centers.get(i).getWeight() / totalWeight);
        }
        return new SampleSummary(sampledPoints, pointList, likelihood);
    }

    public static SampleSummary summarize(float[][] points, int maxAllowed, int initial, boolean reassignPerStep, BiFunction<float[], float[], Double> distance, long seed, Boolean parallelEnabled) {
        ArrayList<Weighted<float[]>> weighted = new ArrayList<Weighted<float[]>>();
        for (float[] point : points) {
            weighted.add(new Weighted<float[]>(point, 1.0f));
        }
        return Summarizer.summarize(weighted, maxAllowed, initial, reassignPerStep, distance, seed, (boolean)parallelEnabled);
    }

    public static SampleSummary l2summarize(List<Weighted<float[]>> points, int maxAllowed, int initial, boolean reassignPerStep, long seed) {
        return Summarizer.summarize(points, maxAllowed, initial, reassignPerStep, Summarizer::L2distance, seed, false);
    }

    public static SampleSummary l2summarize(float[][] points, int maxAllowed, long seed) {
        return Summarizer.summarize(points, maxAllowed, 4 * maxAllowed, false, Summarizer::L2distance, seed, (Boolean)false);
    }

    public static <R> List<ICluster<R>> multiSummarize(List<R> points, int maxAllowed, int initial, int stopAt, boolean phase2GlobalReassign, double overlapParameter, BiFunction<R, R, Double> distance, long seed, Boolean parallelEnabled, double shrinkage, int numberOfRepresentatives) {
        ArrayList<Weighted<R>> weighted = new ArrayList<Weighted<R>>();
        for (R point : points) {
            weighted.add(new Weighted<R>(point, 1.0f));
        }
        BiFunction<Object, Float, ICluster> clusterInitializer = (a, b) -> GenericMultiCenter.initialize(a, b.floatValue(), shrinkage, numberOfRepresentatives);
        return Summarizer.summarize(weighted, maxAllowed, initial, stopAt, phase2GlobalReassign, overlapParameter, distance, clusterInitializer, seed, parallelEnabled, null);
    }

    public static <R> List<ICluster<R>> multiSummarize(R[] points, int maxAllowed, int initial, int stopAt, boolean phase2GlobalReassign, double overlapParameter, BiFunction<R, R, Double> distance, long seed, Boolean parallelEnabled, double shrinkage, int numberOfRepresentatives) {
        ArrayList<Weighted<R>> weighted = new ArrayList<Weighted<R>>();
        for (R point : points) {
            weighted.add(new Weighted<R>(point, 1.0f));
        }
        BiFunction<Object, Float, ICluster> clusterInitializer = (a, b) -> GenericMultiCenter.initialize(a, b.floatValue(), shrinkage, numberOfRepresentatives);
        return Summarizer.summarize(weighted, maxAllowed, initial, stopAt, phase2GlobalReassign, overlapParameter, distance, clusterInitializer, seed, parallelEnabled, null);
    }

    public static List<ICluster<float[]>> multiSummarize(float[][] points, int maxAllowed, double shrinkage, int numberOfRepresentatives, long seed) {
        ArrayList weighted = new ArrayList();
        for (float[] point : points) {
            weighted.add(new Weighted<float[]>(point, 1.0f));
        }
        BiFunction<float[], Float, ICluster> clusterInitializer = (a, b) -> MultiCenter.initialize(a, b.floatValue(), shrinkage, numberOfRepresentatives);
        return Summarizer.summarize(weighted, maxAllowed, 4 * maxAllowed, 1, true, DEFAULT_SEPARATION_RATIO_FOR_MERGE, Summarizer::L2distance, clusterInitializer, seed, true, null);
    }
}

