/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.DateTime;
import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.Image;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Channel {
    private String title;
    private String description;
    private String category;
    private final List<String> categories = new ArrayList<String>();
    private String language;
    private String link;
    private String copyright;
    private String generator;
    private String ttl;
    private String pubDate;
    private String lastBuildDate;
    private String managingEditor;
    private String webMaster;
    private String docs;
    private String rating;
    private Image image;
    private final DateTimeParser dateTimeParser;

    @Deprecated(since="3.5.0", forRemoval=true)
    public Channel() {
        this.dateTimeParser = new DateTime();
    }

    public Channel(DateTimeParser dateTimeParser) {
        this.dateTimeParser = dateTimeParser;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated(since="3.3.0", forRemoval=true)
    public Optional<String> getCategory() {
        return Optional.ofNullable(this.category);
    }

    @Deprecated(since="3.3.0", forRemoval=true)
    public void setCategory(String category) {
        this.category = category;
    }

    public List<String> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public void addCategory(String category) {
        this.category = category;
        this.categories.add(category);
    }

    public Optional<String> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Optional<String> getCopyright() {
        return Optional.ofNullable(this.copyright);
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public Optional<String> getGenerator() {
        return Optional.ofNullable(this.generator);
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public Optional<String> getTtl() {
        return Optional.ofNullable(this.ttl);
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public Optional<String> getPubDate() {
        return Optional.ofNullable(this.pubDate);
    }

    public Optional<ZonedDateTime> getPubDateZonedDateTime() {
        return this.getPubDate().map(this.dateTimeParser::parse);
    }

    public void setPubDate(String pubDate) {
        this.pubDate = pubDate;
    }

    public Optional<String> getLastBuildDate() {
        return Optional.ofNullable(this.lastBuildDate);
    }

    public Optional<ZonedDateTime> getLastBuildDateZonedDateTime() {
        return this.getLastBuildDate().map(this.dateTimeParser::parse);
    }

    public void setLastBuildDate(String lastBuildDate) {
        this.lastBuildDate = lastBuildDate;
    }

    public Optional<String> getManagingEditor() {
        return Optional.ofNullable(this.managingEditor);
    }

    public void setManagingEditor(String managingEditor) {
        this.managingEditor = managingEditor;
    }

    public Optional<String> getWebMaster() {
        return Optional.ofNullable(this.webMaster);
    }

    public void setWebMaster(String webMaster) {
        this.webMaster = webMaster;
    }

    public String getDocs() {
        return this.docs;
    }

    public void setDocs(String docs) {
        this.docs = docs;
    }

    public String getRating() {
        return this.rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public Optional<Image> getImage() {
        return Optional.ofNullable(this.image);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel = (Channel)o;
        return Objects.equals(this.getTitle(), channel.getTitle()) && Objects.equals(this.getDescription(), channel.getDescription()) && this.getCategories().equals(channel.getCategories()) && Objects.equals(this.getLanguage(), channel.getLanguage()) && Objects.equals(this.getLink(), channel.getLink()) && Objects.equals(this.getCopyright(), channel.getCopyright()) && Objects.equals(this.getGenerator(), channel.getGenerator()) && Objects.equals(this.getTtl(), channel.getTtl()) && Objects.equals(this.getPubDate(), channel.getPubDate()) && Objects.equals(this.getLastBuildDate(), channel.getLastBuildDate()) && Objects.equals(this.getManagingEditor(), channel.getManagingEditor()) && Objects.equals(this.getWebMaster(), channel.getWebMaster()) && Objects.equals(this.getDocs(), channel.getDocs()) && Objects.equals(this.getRating(), channel.getRating()) && Objects.equals(this.getImage(), channel.getImage());
    }

    public int hashCode() {
        return Objects.hash(this.getTitle(), this.getDescription(), this.getCategories(), this.getLanguage(), this.getLink(), this.getCopyright(), this.getGenerator(), this.getTtl(), this.getPubDate(), this.getLastBuildDate(), this.getManagingEditor(), this.getWebMaster(), this.getDocs(), this.getRating(), this.getImage());
    }
}

