/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.google.api.HttpRule;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RouteBuilder;
import com.linecorp.armeria.server.grpc.HttpJsonTranscodingPathParser;
import com.linecorp.armeria.server.grpc.HttpJsonTranscodingService;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpJsonTranscodingRouteAndPathVariables {
    private static final Logger logger = LoggerFactory.getLogger(HttpJsonTranscodingRouteAndPathVariables.class);
    private final Route route;
    private final List<HttpJsonTranscodingService.PathVariable> pathVariables;
    private final boolean hasVerb;

    @Nullable
    static HttpJsonTranscodingRouteAndPathVariables of(HttpRule httpRule) {
        boolean hasVerb;
        HttpJsonTranscodingPathParser.PathSegment.PathMappingType pathMappingType;
        String path;
        RouteBuilder builder = Route.builder();
        switch (httpRule.getPatternCase()) {
            case GET: {
                builder.methods(new HttpMethod[]{HttpMethod.GET});
                path = httpRule.getGet();
                break;
            }
            case PUT: {
                builder.methods(new HttpMethod[]{HttpMethod.PUT});
                path = httpRule.getPut();
                break;
            }
            case POST: {
                builder.methods(new HttpMethod[]{HttpMethod.POST});
                path = httpRule.getPost();
                break;
            }
            case DELETE: {
                builder.methods(new HttpMethod[]{HttpMethod.DELETE});
                path = httpRule.getDelete();
                break;
            }
            case PATCH: {
                builder.methods(new HttpMethod[]{HttpMethod.PATCH});
                path = httpRule.getPatch();
                break;
            }
            default: {
                logger.warn("Ignoring unsupported route pattern: pattern={}, httpRule={}", (Object)httpRule.getPatternCase(), (Object)httpRule);
                return null;
            }
        }
        if (path.startsWith("exact:") || path.startsWith("prefix:") || path.startsWith("glob:") || path.startsWith("regex:")) {
            Route route = builder.path(path).build();
            List vars = (List)route.paramNames().stream().map(name -> new HttpJsonTranscodingService.PathVariable(null, (String)name, (List<HttpJsonTranscodingService.PathVariable.ValueDefinition>)ImmutableList.of((Object)new HttpJsonTranscodingService.PathVariable.ValueDefinition(HttpJsonTranscodingService.PathVariable.ValueDefinition.Type.REFERENCE, (String)name)))).collect(ImmutableList.toImmutableList());
            boolean hasVerb2 = false;
            if (path.startsWith("exact:")) {
                hasVerb2 = HttpJsonTranscodingRouteAndPathVariables.containsVerbPath(path, true);
            } else if (path.startsWith("glob:") || path.startsWith("regex:")) {
                hasVerb2 = HttpJsonTranscodingRouteAndPathVariables.containsVerbPath((String)route.paths().get(0), false);
            }
            return new HttpJsonTranscodingRouteAndPathVariables(route, vars, hasVerb2);
        }
        List<HttpJsonTranscodingPathParser.PathSegment> segments = HttpJsonTranscodingPathParser.parse(path);
        HttpJsonTranscodingPathParser.PathSegment.PathMappingType pathMappingType2 = pathMappingType = segments.stream().allMatch(segment -> segment.support(HttpJsonTranscodingPathParser.PathSegment.PathMappingType.PARAMETERIZED)) ? HttpJsonTranscodingPathParser.PathSegment.PathMappingType.PARAMETERIZED : HttpJsonTranscodingPathParser.PathSegment.PathMappingType.GLOB;
        if (segments.get(segments.size() - 1) instanceof HttpJsonTranscodingPathParser.VerbPathSegment) {
            pathMappingType = HttpJsonTranscodingPathParser.PathSegment.PathMappingType.REGEX;
            hasVerb = true;
        } else {
            hasVerb = false;
        }
        if (pathMappingType == HttpJsonTranscodingPathParser.PathSegment.PathMappingType.PARAMETERIZED) {
            builder.path(HttpJsonTranscodingPathParser.Stringifier.segmentsToPath(HttpJsonTranscodingPathParser.PathSegment.PathMappingType.PARAMETERIZED, segments, true));
        } else if (pathMappingType == HttpJsonTranscodingPathParser.PathSegment.PathMappingType.GLOB) {
            builder.glob(HttpJsonTranscodingPathParser.Stringifier.segmentsToPath(HttpJsonTranscodingPathParser.PathSegment.PathMappingType.GLOB, segments, true));
        } else {
            builder.regex('^' + HttpJsonTranscodingPathParser.Stringifier.segmentsToPath(HttpJsonTranscodingPathParser.PathSegment.PathMappingType.REGEX, segments, true) + '$');
        }
        return new HttpJsonTranscodingRouteAndPathVariables(builder.build(), HttpJsonTranscodingService.PathVariable.from(segments, pathMappingType), hasVerb);
    }

    private static boolean containsVerbPath(String path, boolean exact) {
        String verbPathRegex = exact ? "(?<!/):[A-Za-z0-9]+$" : "(?<!/):[A-Za-z]+\\$(?!/)";
        Pattern pattern = Pattern.compile(verbPathRegex);
        Matcher matcher = pattern.matcher(path);
        return matcher.find();
    }

    private HttpJsonTranscodingRouteAndPathVariables(Route route, List<HttpJsonTranscodingService.PathVariable> pathVariables, boolean hasVerb) {
        this.route = route;
        this.pathVariables = pathVariables;
        this.hasVerb = hasVerb;
    }

    Route route() {
        return this.route;
    }

    List<HttpJsonTranscodingService.PathVariable> pathVariables() {
        return this.pathVariables;
    }

    boolean hasVerb() {
        return this.hasVerb;
    }
}

