/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.atlassian.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import org.opensearch.dataprepper.plugins.source.atlassian.configuration.BasicConfig;
import org.opensearch.dataprepper.plugins.source.atlassian.configuration.Oauth2Config;

public class AuthenticationConfig {
    @JsonProperty(value="basic")
    @Valid
    private BasicConfig basicConfig;
    @JsonProperty(value="oauth2")
    @Valid
    private Oauth2Config oauth2Config;

    @AssertTrue(message="Authentication config should have either basic or oauth2")
    private @AssertTrue(message="Authentication config should have either basic or oauth2") boolean isValidAuthenticationConfig() {
        boolean hasBasic = this.basicConfig != null;
        boolean hasOauth = this.oauth2Config != null;
        return hasBasic ^ hasOauth;
    }

    public String getAuthType() {
        if (this.basicConfig != null) {
            return "Basic";
        }
        return "OAuth2";
    }

    public BasicConfig getBasicConfig() {
        return this.basicConfig;
    }

    public Oauth2Config getOauth2Config() {
        return this.oauth2Config;
    }
}

