/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source.apihandler;

import com.linecorp.armeria.client.retry.Backoff;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import org.opensearch.dataprepper.plugins.kinesis.source.exceptions.KinesisRetriesExhaustedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisClientApiRetryHandler {
    private static final Logger log = LoggerFactory.getLogger(KinesisClientApiRetryHandler.class);
    private final Backoff backoff;
    private final int maxRetryCount;

    public KinesisClientApiRetryHandler(Backoff backoff, int maxRetryCount) {
        if (maxRetryCount <= 0) {
            throw new IllegalArgumentException("Maximum Retry count should be strictly greater than zero.");
        }
        this.backoff = Objects.requireNonNull(backoff, "Backoff cannot be null");
        this.maxRetryCount = maxRetryCount;
    }

    public <T> T executeWithRetry(String operationName, Supplier<T> operation, ExceptionHandler exceptionHandler) {
        Objects.requireNonNull(operationName, "Operation name cannot be null");
        Objects.requireNonNull(operation, "Operation cannot be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler cannot be null");
        for (int attempt = 0; attempt < this.maxRetryCount; ++attempt) {
            try {
                return operation.get();
            }
            catch (Exception ex) {
                exceptionHandler.handle(ex, attempt);
                this.applyBackoff(attempt);
                continue;
            }
        }
        throw new KinesisRetriesExhaustedException(String.format("Failed to execute %s after %d retries", operationName, this.maxRetryCount));
    }

    private void applyBackoff(int attempt) {
        long delayMillis = this.backoff.nextDelayMillis(attempt);
        if (delayMillis < 0L) {
            throw new KinesisRetriesExhaustedException("Retries exhausted. Make sure that configuration is valid and required permissions are present.");
        }
        this.sleep(delayMillis);
    }

    private void sleep(long delayMillis) {
        if (delayMillis <= 0L) {
            return;
        }
        Duration delayDuration = Duration.ofMillis(delayMillis);
        log.info("Pausing request for {}.{} seconds due to an error in processing.", (Object)delayDuration.getSeconds(), (Object)delayDuration.toMillisPart());
        try {
            Thread.sleep(delayMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface ExceptionHandler {
        public void handle(Exception var1, int var2);
    }
}

