/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source;

import com.amazonaws.SdkClientException;
import com.linecorp.armeria.client.retry.Backoff;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.kinesis.extension.KinesisLeaseConfig;
import org.opensearch.dataprepper.plugins.kinesis.extension.KinesisLeaseConfigSupplier;
import org.opensearch.dataprepper.plugins.kinesis.source.KinesisClientFactory;
import org.opensearch.dataprepper.plugins.kinesis.source.KinesisMultiStreamTracker;
import org.opensearch.dataprepper.plugins.kinesis.source.WorkerIdentifierGenerator;
import org.opensearch.dataprepper.plugins.kinesis.source.apihandler.KinesisClientApiHandler;
import org.opensearch.dataprepper.plugins.kinesis.source.apihandler.KinesisClientApiRetryHandler;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.ConsumerStrategy;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.KinesisSourceConfig;
import org.opensearch.dataprepper.plugins.kinesis.source.processor.KinesisShardRecordProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.common.ConfigsBuilder;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.exceptions.KinesisClientLibDependencyException;
import software.amazon.kinesis.exceptions.ThrottlingException;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.processor.StreamTracker;
import software.amazon.kinesis.retrieval.RetrievalConfig;
import software.amazon.kinesis.retrieval.RetrievalSpecificConfig;
import software.amazon.kinesis.retrieval.polling.PollingConfig;

public class KinesisService {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisService.class);
    private static final int GRACEFUL_SHUTDOWN_WAIT_INTERVAL_SECONDS = 20;
    private static final long INITIAL_DELAY = Duration.ofSeconds(20L).toMillis();
    private static final long MAXIMUM_DELAY = Duration.ofMinutes(5L).toMillis();
    private static final double JITTER_RATE = 0.2;
    private static final int NUM_OF_RETRIES = 3;
    private final PluginMetrics pluginMetrics;
    private final PluginFactory pluginFactory;
    private final String applicationName;
    private final String tableName;
    private final String kclMetricsNamespaceName;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final KinesisSourceConfig kinesisSourceConfig;
    private final KinesisAsyncClient kinesisClient;
    private final DynamoDbAsyncClient dynamoDbClient;
    private final CloudWatchAsyncClient cloudWatchClient;
    private final WorkerIdentifierGenerator workerIdentifierGenerator;
    private final InputCodec codec;
    private Scheduler scheduler;
    private final ExecutorService executorService;

    public KinesisService(KinesisSourceConfig kinesisSourceConfig, KinesisClientFactory kinesisClientFactory, PluginMetrics pluginMetrics, PluginFactory pluginFactory, PipelineDescription pipelineDescription, AcknowledgementSetManager acknowledgementSetManager, KinesisLeaseConfigSupplier kinesisLeaseConfigSupplier, WorkerIdentifierGenerator workerIdentifierGenerator) {
        this.kinesisSourceConfig = kinesisSourceConfig;
        this.pluginMetrics = pluginMetrics;
        this.pluginFactory = pluginFactory;
        this.acknowledgementSetManager = acknowledgementSetManager;
        if (kinesisLeaseConfigSupplier.getKinesisExtensionLeaseConfig().isEmpty()) {
            throw new IllegalStateException("Lease Coordination table should be provided!");
        }
        KinesisLeaseConfig kinesisLeaseConfig = kinesisLeaseConfigSupplier.getKinesisExtensionLeaseConfig().get();
        this.kclMetricsNamespaceName = this.tableName = kinesisLeaseConfig.getLeaseCoordinationTable().getTableName();
        this.dynamoDbClient = kinesisClientFactory.buildDynamoDBClient(kinesisLeaseConfig.getLeaseCoordinationTable().getAwsRegion());
        this.kinesisClient = kinesisClientFactory.buildKinesisAsyncClient(kinesisSourceConfig.getAwsAuthenticationConfig().getAwsRegion());
        this.cloudWatchClient = kinesisClientFactory.buildCloudWatchAsyncClient(kinesisLeaseConfig.getLeaseCoordinationTable().getAwsRegion());
        String pipelineIdentifier = kinesisLeaseConfig.getPipelineIdentifier();
        this.applicationName = Objects.isNull(pipelineIdentifier) || pipelineIdentifier.isEmpty() ? pipelineDescription.getPipelineName() : kinesisLeaseConfig.getPipelineIdentifier();
        this.workerIdentifierGenerator = workerIdentifierGenerator;
        this.executorService = Executors.newFixedThreadPool(1);
        PluginModel codecConfiguration = kinesisSourceConfig.getCodec();
        PluginSetting codecPluginSettings = new PluginSetting(codecConfiguration.getPluginName(), codecConfiguration.getPluginSettings());
        this.codec = (InputCodec)pluginFactory.loadPlugin(InputCodec.class, codecPluginSettings, new Object[0]);
    }

    public void start(Buffer<Record<Event>> buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Buffer provided is null.");
        }
        if (this.kinesisSourceConfig.getStreams() == null || this.kinesisSourceConfig.getStreams().isEmpty()) {
            throw new InvalidPluginConfigurationException("No Kinesis streams provided.");
        }
        this.scheduler = this.getScheduler(buffer);
        this.executorService.execute((Runnable)this.scheduler);
    }

    public void shutDown() {
        LOG.info("Stop request received for Kinesis Source");
        if (this.scheduler != null) {
            CompletableFuture gracefulShutdownFuture = this.scheduler.startGracefulShutdown();
            LOG.info("Waiting up to {} seconds for shutdown to complete.", (Object)20);
            try {
                gracefulShutdownFuture.get(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                LOG.error("Exception while executing kinesis consumer graceful shutdown, doing force shutdown", (Throwable)ex);
                this.scheduler.shutdown();
            }
            LOG.info("Completed, shutting down now.");
        } else {
            LOG.info("The Kinesis Scheduler was not initialized.");
        }
    }

    public Scheduler getScheduler(Buffer<Record<Event>> buffer) {
        int maxAttempts = this.kinesisSourceConfig.getMaxInitializationAttempts();
        while (this.scheduler == null && maxAttempts-- > 0) {
            try {
                this.scheduler = this.createScheduler(buffer);
            }
            catch (SdkClientException | KinesisClientLibDependencyException | ThrottlingException ex) {
                LOG.error(DataPrepperMarkers.NOISY, "Caught exception when initializing KCL Scheduler due to {}. Number of remaining retries: {}", (Object)ex.getMessage(), (Object)maxAttempts);
            }
            catch (Exception ex) {
                LOG.error(DataPrepperMarkers.NOISY, "Caught exception when initializing KCL Scheduler. Number of remaining retries: {}", (Object)maxAttempts, (Object)ex);
            }
            if (this.scheduler != null) continue;
            try {
                Thread.sleep(this.kinesisSourceConfig.getInitializationBackoffTime().toMillis());
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted exception.");
            }
        }
        return this.scheduler;
    }

    public Scheduler createScheduler(Buffer<Record<Event>> buffer) {
        KinesisShardRecordProcessorFactory processorFactory = new KinesisShardRecordProcessorFactory(buffer, this.kinesisSourceConfig, this.acknowledgementSetManager, this.pluginMetrics, this.codec);
        ConfigsBuilder configsBuilder = new ConfigsBuilder((StreamTracker)new KinesisMultiStreamTracker(this.kinesisSourceConfig, this.applicationName, new KinesisClientApiHandler(this.kinesisClient, new KinesisClientApiRetryHandler(Backoff.exponential((long)INITIAL_DELAY, (long)MAXIMUM_DELAY).withJitter(0.2).withMaxAttempts(3), 3))), this.applicationName, this.kinesisClient, this.dynamoDbClient, this.cloudWatchClient, this.workerIdentifierGenerator.generate(), (ShardRecordProcessorFactory)processorFactory).tableName(this.tableName).namespace(this.kclMetricsNamespaceName);
        RetrievalConfig retrievalConfig = configsBuilder.retrievalConfig();
        ConsumerStrategy consumerStrategy = this.kinesisSourceConfig.getConsumerStrategy();
        if (consumerStrategy == ConsumerStrategy.POLLING) {
            retrievalConfig = configsBuilder.retrievalConfig().retrievalSpecificConfig((RetrievalSpecificConfig)new PollingConfig(this.kinesisClient).maxRecords(this.kinesisSourceConfig.getPollingConfig().getMaxPollingRecords()).idleTimeBetweenReadsInMillis(this.kinesisSourceConfig.getPollingConfig().getIdleTimeBetweenReads().toMillis()));
        }
        return new Scheduler(configsBuilder.checkpointConfig(), configsBuilder.coordinatorConfig().schedulerInitializationBackoffTimeMillis(this.kinesisSourceConfig.getInitializationBackoffTime().toMillis()).maxInitializationAttempts(this.kinesisSourceConfig.getMaxInitializationAttempts()), configsBuilder.leaseManagementConfig().billingMode(BillingMode.PAY_PER_REQUEST), configsBuilder.lifecycleConfig(), configsBuilder.metricsConfig(), configsBuilder.processorConfig(), retrievalConfig);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

