/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Named;
import org.opensearch.dataprepper.model.annotations.Experimental;
import org.opensearch.dataprepper.model.plugin.NoPluginFoundException;
import org.opensearch.dataprepper.plugin.DefinedPlugin;
import org.opensearch.dataprepper.plugin.ExperimentalConfiguration;
import org.opensearch.dataprepper.plugin.ExperimentalConfigurationContainer;

@Named
class ExperimentalPluginValidator
implements Consumer<DefinedPlugin<?>> {
    private final ExperimentalConfiguration experimentalConfiguration;

    ExperimentalPluginValidator(ExperimentalConfigurationContainer experimentalConfigurationContainer) {
        this.experimentalConfiguration = experimentalConfigurationContainer.getExperimental();
    }

    @Override
    public void accept(DefinedPlugin<?> definedPlugin) {
        if (this.isPluginDisallowedAsExperimental(definedPlugin)) {
            throw new NoPluginFoundException("Unable to create experimental plugin " + definedPlugin.getPluginName() + ". You must enable experimental plugins in data-prepper-config.yaml in order to use them.");
        }
    }

    private boolean isPluginDisallowedAsExperimental(DefinedPlugin<?> definedPlugin) {
        Class<?> pluginClass = definedPlugin.getPluginClass();
        if (!pluginClass.isAnnotationPresent(Experimental.class)) {
            return false;
        }
        if (this.experimentalConfiguration.isEnableAll()) {
            return false;
        }
        Set enabledPluginsForType = this.experimentalConfiguration.getEnabledPlugins().getOrDefault(definedPlugin.getPluginTypeName(), Collections.emptySet());
        return !enabledPluginsForType.contains(definedPlugin.getPluginName());
    }
}

