/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.model.plugin.ExtensionPoints;
import org.opensearch.dataprepper.model.plugin.ExtensionProvider;
import org.opensearch.dataprepper.plugin.PluginBeanFactoryProvider;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.support.GenericApplicationContext;

@Named
public class DataPrepperExtensionPoints
implements ExtensionPoints {
    private static final ExtensionProvider.Context EMPTY_CONTEXT = new EmptyContext();
    private final GenericApplicationContext sharedApplicationContext;
    private final GenericApplicationContext coreApplicationContext;
    private Set<Class> providerClassesSet;

    @Inject
    public DataPrepperExtensionPoints(PluginBeanFactoryProvider pluginBeanFactoryProvider) {
        Objects.requireNonNull(pluginBeanFactoryProvider);
        Objects.requireNonNull(pluginBeanFactoryProvider.getCoreApplicationContext());
        Objects.requireNonNull(pluginBeanFactoryProvider.getSharedPluginApplicationContext());
        this.sharedApplicationContext = pluginBeanFactoryProvider.getSharedPluginApplicationContext();
        this.coreApplicationContext = pluginBeanFactoryProvider.getCoreApplicationContext();
        this.providerClassesSet = new HashSet<Class>();
    }

    public void addExtensionProvider(ExtensionProvider extensionProvider) {
        if (this.providerClassesSet.contains(extensionProvider.supportedClass())) {
            return;
        }
        this.coreApplicationContext.registerBean(extensionProvider.supportedClass(), () -> extensionProvider.provideInstance(EMPTY_CONTEXT).orElse(null), new BeanDefinitionCustomizer[]{b -> b.setScope("prototype")});
        this.sharedApplicationContext.registerBean(extensionProvider.supportedClass(), () -> extensionProvider.provideInstance(EMPTY_CONTEXT), new BeanDefinitionCustomizer[]{b -> b.setScope("prototype")});
        this.providerClassesSet.add(extensionProvider.supportedClass());
    }

    public <T> T getExtensionProvider(Class<T> type) {
        this.sharedApplicationContext.refresh();
        return (T)this.sharedApplicationContext.getBean(type);
    }

    private static class EmptyContext
    implements ExtensionProvider.Context {
        private EmptyContext() {
        }
    }
}

