/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.model.plugin.ExtensionPlugin;
import org.opensearch.dataprepper.plugin.ExtensionClassProvider;
import org.opensearch.dataprepper.plugin.PluginPackagesSupplier;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ClasspathExtensionClassProvider
implements ExtensionClassProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathExtensionClassProvider.class);
    private final Reflections reflections;
    private Set<Class<? extends ExtensionPlugin>> extensionPluginClasses;

    @Inject
    public ClasspathExtensionClassProvider() {
        this(ClasspathExtensionClassProvider.createReflections());
    }

    private static Reflections createReflections() {
        String[] packages = new PluginPackagesSupplier().get();
        FilterBuilder filterBuilder = new FilterBuilder();
        for (String packageToInclude : packages) {
            filterBuilder = filterBuilder.includePackage(packageToInclude);
        }
        return new Reflections((Configuration)new ConfigurationBuilder().forPackages(packages).filterInputsBy((Predicate)filterBuilder));
    }

    ClasspathExtensionClassProvider(Reflections reflections) {
        this.reflections = reflections;
    }

    @Override
    public Collection<Class<? extends ExtensionPlugin>> loadExtensionPluginClasses() {
        if (this.extensionPluginClasses == null) {
            this.extensionPluginClasses = this.scanForExtensionPlugins();
        }
        return this.extensionPluginClasses;
    }

    private Set<Class<? extends ExtensionPlugin>> scanForExtensionPlugins() {
        Set extensionClasses = this.reflections.getSubTypesOf(ExtensionPlugin.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} extension classes.", (Object)extensionClasses.size());
            LOG.debug("Extensions classes: {}", (Object)extensionClasses.stream().map(Class::getName).collect(Collectors.joining(", ")));
        }
        return extensionClasses;
    }
}

