/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.opensearch.dataprepper.expression.ExpressionFunction;
import org.opensearch.dataprepper.model.event.Event;

@Named
public class HasTagsExpressionFunction
implements ExpressionFunction {
    @Override
    public String getFunctionName() {
        return "hasTags";
    }

    @Override
    public Object evaluate(List<Object> args, Event event, Function<Object, Object> convertLiteralType) {
        if (args.size() == 0) {
            throw new RuntimeException("hasTags() takes at least one argument");
        }
        if (!args.stream().allMatch(a -> a instanceof String && ((String)a).length() > 0 && ((String)a).charAt(0) == '\"')) {
            throw new RuntimeException("hasTags() takes only non-empty string literal type arguments");
        }
        List tags = args.stream().map(a -> {
            String str = (String)a;
            return str.substring(1, str.length() - 1);
        }).collect(Collectors.toList());
        return event.getMetadata().hasTags(tags);
    }
}

