/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import java.util.regex.PatternSyntaxException;
import org.antlr.v4.runtime.RuleContext;
import org.opensearch.dataprepper.expression.Operator;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionParser;

class GenericRegexMatchOperator
implements Operator<Boolean> {
    private final int symbol;
    private final String displayName;
    private final BiPredicate<Object, Object> operation;

    public GenericRegexMatchOperator(int symbol, BiPredicate<Object, Object> operation) {
        this.symbol = symbol;
        this.displayName = DataPrepperExpressionParser.VOCABULARY.getDisplayName(symbol);
        this.operation = operation;
    }

    @Override
    public boolean isBooleanOperator() {
        return true;
    }

    @Override
    public boolean shouldEvaluate(RuleContext ctx) {
        return ctx.getRuleIndex() == 10;
    }

    @Override
    public int getSymbol() {
        return this.symbol;
    }

    @Override
    public Boolean evaluate(Object ... args) {
        Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)(this.displayName + " requires operands length needs to be 2."));
        if (args[0] == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(args[0] instanceof String), (Object)(this.displayName + " requires left operand to be String."));
        Preconditions.checkArgument((boolean)(args[1] instanceof String), (Object)(this.displayName + " requires right operand to be String."));
        try {
            return this.operation.test(args[0], args[1]);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

