/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.List;
import java.util.function.Function;
import javax.inject.Named;
import org.opensearch.dataprepper.expression.ExpressionFunction;
import org.opensearch.dataprepper.model.event.Event;

@Named
public class ContainsExpressionFunction
implements ExpressionFunction {
    private static final int NUMBER_OF_ARGS = 2;

    @Override
    public String getFunctionName() {
        return "contains";
    }

    @Override
    public Object evaluate(List<Object> args, Event event, Function<Object, Object> convertLiteralType) {
        if (args.size() != 2) {
            throw new RuntimeException("contains() takes exactly two arguments");
        }
        String[] strArgs = new String[2];
        for (int i = 0; i < 2; ++i) {
            Object arg = args.get(i);
            if (!(arg instanceof String)) {
                throw new RuntimeException(String.format("containsSubstring() takes only string type arguments. \"%s\" is not of type string", arg));
            }
            String str = (String)arg;
            if (str.charAt(0) == '\"') {
                strArgs[i] = str.substring(1, str.length() - 1);
                continue;
            }
            if (str.charAt(0) == '/') {
                Object obj = event.get(str, Object.class);
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof String)) {
                    throw new RuntimeException(String.format("containsSubstring() takes only string type arguments. \"%s\" is not of type string", obj));
                }
                strArgs[i] = (String)obj;
                continue;
            }
            throw new RuntimeException(String.format("Arguments to contains() must be a literal string or a Json Pointer. \"%s\" is not string literal or json pointer", str));
        }
        return strArgs[0].contains(strArgs[1]);
    }
}

