/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.opensearch.dataprepper.expression.ExpressionFunction;
import org.opensearch.dataprepper.model.event.Event;

@Named
public class CidrExpressionFunction
implements ExpressionFunction {
    private static final String FUNCTION_NAME = "cidrContains";

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Object evaluate(List<Object> args, Event event, Function<Object, Object> convertLiteralType) {
        List argStrings;
        if (args.size() <= 1) {
            throw new IllegalArgumentException("cidrContains() takes at least two arguments");
        }
        try {
            argStrings = args.stream().map(arg -> ((String)arg).trim()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Arguments in cidrContains() function should be of Json Pointer type or String type");
        }
        String ipAddressInEvent = (String)event.get((String)argStrings.get(0), String.class);
        List<String> cidrBlockStrs = argStrings.subList(1, argStrings.size()).stream().map(str -> str.substring(1, str.length() - 1)).collect(Collectors.toList());
        return this.isIpInCidr(ipAddressInEvent, cidrBlockStrs);
    }

    private boolean isIpInCidr(String ipAddressStr, List<String> cidrBlockStrs) {
        if (Objects.isNull(ipAddressStr)) {
            return false;
        }
        IPAddress address = new IPAddressString(ipAddressStr).getAddress();
        List cidrBlocks = cidrBlockStrs.stream().map(blockStr -> new IPAddressString(blockStr).getAddress()).collect(Collectors.toList());
        for (IPAddress cidrBlock : cidrBlocks) {
            if (!cidrBlock.contains(address)) continue;
            return true;
        }
        return false;
    }
}

