/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.RuleContext;
import org.opensearch.dataprepper.expression.Operator;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionParser;

class ArithmeticSubtractOperator
implements Operator<Number> {
    private final int symbol;
    private final String displayName;
    private final Map<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>> operandsToOperationMap;
    private final Map<Class<? extends Number>, Function<Number, ? extends Number>> strategy;

    public ArithmeticSubtractOperator(int symbol, Map<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>> operandsToOperationMap, Map<Class<? extends Number>, Function<Number, ? extends Number>> strategy) {
        this.symbol = symbol;
        this.displayName = DataPrepperExpressionParser.VOCABULARY.getDisplayName(symbol);
        this.operandsToOperationMap = operandsToOperationMap;
        this.strategy = strategy;
    }

    @Override
    public boolean isBooleanOperator() {
        return false;
    }

    @Override
    public int getNumberOfOperands(RuleContext ctx) {
        if (ctx.getRuleIndex() == 2) {
            return 2;
        }
        return 1;
    }

    @Override
    public boolean shouldEvaluate(RuleContext ctx) {
        return ctx.getRuleIndex() == 2 || ctx.getRuleIndex() == 5;
    }

    @Override
    public int getSymbol() {
        return this.symbol;
    }

    @Override
    public Number evaluate(Object ... args) {
        if (args.length == 1) {
            if (args[0] instanceof Number) {
                return this.strategy.get(args[0].getClass()).apply((Number)args[0]);
            }
            throw new IllegalArgumentException(this.displayName + " requires operand to be either Float or Integer.");
        }
        Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)(this.displayName + " requires operands length needs to be 2."));
        Object leftValue = args[0];
        Object rightValue = args[1];
        Preconditions.checkArgument((leftValue != null && rightValue != null ? 1 : 0) != 0, (Object)(this.displayName + " requires operands length needs to be non-null."));
        Class<?> leftValueClass = leftValue.getClass();
        Class<?> rightValueClass = rightValue.getClass();
        if (!this.operandsToOperationMap.containsKey(leftValueClass)) {
            throw new IllegalArgumentException(this.displayName + " requires left operand to be either Float or Integer.");
        }
        Map<Class<? extends Number>, BiFunction<Object, Object, Number>> rightOperandToOperation = this.operandsToOperationMap.get(leftValueClass);
        if (!rightOperandToOperation.containsKey(rightValueClass)) {
            throw new IllegalArgumentException(this.displayName + " requires right operand to be either Float or Integer.");
        }
        BiFunction<Object, Object, Number> operation = rightOperandToOperation.get(rightValueClass);
        return operation.apply(leftValue, rightValue);
    }
}

