/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.function.BiFunction;
import org.antlr.v4.runtime.RuleContext;
import org.opensearch.dataprepper.expression.Operator;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionParser;

class ArithmeticBinaryOperator
implements Operator<Number> {
    private final int symbol;
    private final String displayName;
    private final Map<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>> operandsToOperationMap;

    @Override
    public boolean isBooleanOperator() {
        return false;
    }

    public ArithmeticBinaryOperator(int symbol, Map<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>> operandsToOperationMap) {
        this.symbol = symbol;
        this.displayName = DataPrepperExpressionParser.VOCABULARY.getDisplayName(symbol);
        this.operandsToOperationMap = operandsToOperationMap;
    }

    @Override
    public boolean shouldEvaluate(RuleContext ctx) {
        return ctx.getRuleIndex() == 3;
    }

    @Override
    public int getSymbol() {
        return this.symbol;
    }

    @Override
    public Number evaluate(Object ... args) {
        Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)(this.displayName + " requires operands length needs to be 2."));
        Object leftValue = args[0];
        Object rightValue = args[1];
        Preconditions.checkArgument((leftValue != null && rightValue != null ? 1 : 0) != 0, (Object)(this.displayName + " requires operands length needs to be non-null."));
        Class<?> leftValueClass = leftValue.getClass();
        Class<?> rightValueClass = rightValue.getClass();
        if (!this.operandsToOperationMap.containsKey(leftValueClass)) {
            if (this.symbol == 39) {
                throw new IllegalArgumentException(this.displayName + " requires left operand to be an Integer.");
            }
            throw new IllegalArgumentException(this.displayName + " requires left operand to be either Float or Integer.");
        }
        Map<Class<? extends Number>, BiFunction<Object, Object, Number>> rightOperandToOperation = this.operandsToOperationMap.get(leftValueClass);
        if (!rightOperandToOperation.containsKey(rightValueClass)) {
            if (this.symbol == 39) {
                throw new IllegalArgumentException(this.displayName + " requires right operand to be an Integer.");
            }
            throw new IllegalArgumentException(this.displayName + " requires right operand to be either Float or Integer.");
        }
        BiFunction<Object, Object, Number> operation = rightOperandToOperation.get(rightValueClass);
        return operation.apply(leftValue, rightValue);
    }
}

