/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.parquet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.avro.generic.GenericRecord;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.hadoop.ParquetReader;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.DecompressionEngine;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventBuilder;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.io.InputFile;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.codec.parquet.GenericRecordJsonEncoder;
import org.opensearch.dataprepper.plugins.fs.LocalInputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="parquet", pluginType=InputCodec.class)
public class ParquetInputCodec
implements InputCodec {
    static final String EVENT_TYPE = "event";
    static final String FILE_PREFIX = "parquet-data";
    static final String FILE_SUFFIX = ".parquet";
    private static final Logger LOG = LoggerFactory.getLogger(ParquetInputCodec.class);
    private final ParquetConfiguration configuration;
    private final EventFactory eventFactory;

    @DataPrepperPluginConstructor
    public ParquetInputCodec(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
        this.configuration = new PlainParquetConfiguration();
        this.configuration.setBoolean("parquet.avro.readInt96AsFixed", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, Consumer<Record<Event>> eventConsumer) throws IOException {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(eventConsumer);
        File tempFile = File.createTempFile(FILE_PREFIX, FILE_SUFFIX);
        Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        try {
            this.parseParquetFile((InputFile)new LocalInputFile(tempFile), eventConsumer);
        }
        finally {
            Files.delete(tempFile.toPath());
        }
    }

    public void parse(InputFile inputFile, DecompressionEngine decompressionEngine, Consumer<Record<Event>> eventConsumer) throws IOException {
        Objects.requireNonNull(inputFile);
        Objects.requireNonNull(eventConsumer);
        this.parseParquetFile(inputFile, eventConsumer);
    }

    private void parseParquetFile(InputFile inputFile, Consumer<Record<Event>> eventConsumer) throws IOException {
        try (ParquetReader reader = AvroParquetReader.builder((org.apache.parquet.io.InputFile)inputFile, (ParquetConfiguration)this.configuration).build();){
            GenericRecordJsonEncoder encoder = new GenericRecordJsonEncoder();
            GenericRecord record = null;
            while ((record = (GenericRecord)reader.read()) != null) {
                String json = encoder.serialize(record);
                Event event = ((EventBuilder)this.eventFactory.eventBuilder(EventBuilder.class)).withEventType(EVENT_TYPE).withData((Object)json).build();
                eventConsumer.accept((Record<Event>)new Record((Object)event));
            }
        }
        catch (Exception e) {
            LOG.error("An exception occurred while parsing parquet InputStream ", (Throwable)e);
            throw new IOException(e);
        }
    }
}

