/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.aws.api;

import java.util.UUID;
import org.opensearch.dataprepper.aws.api.AwsContext;
import org.opensearch.dataprepper.aws.api.AwsCredentialsConfig;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AwsContextImpl
implements AwsContext {
    private final AwsCredentialsConfig awsCredentialsConfig;

    public AwsContextImpl(AwsCredentialsConfig awsCredentialsConfig) {
        this.awsCredentialsConfig = awsCredentialsConfig;
    }

    @Override
    public AwsCredentialsProvider getOrDefault() {
        if (this.awsCredentialsConfig == null || this.awsCredentialsConfig.getStsRoleArn() == null) {
            return this.getDefault();
        }
        return this.getFromOptions(this.awsCredentialsConfig.toCredentialsOptions());
    }

    @Override
    public Region getRegionOrDefault() {
        if (this.awsCredentialsConfig != null && this.awsCredentialsConfig.getRegion() != null) {
            return Region.of((String)this.awsCredentialsConfig.getRegion());
        }
        return null;
    }

    private AwsCredentialsProvider getDefault() {
        AwsCredentialsOptions credentialsOptions = this.awsCredentialsConfig != null ? this.awsCredentialsConfig.toCredentialsOptions() : AwsCredentialsOptions.defaultOptions();
        return this.getFromOptions(credentialsOptions);
    }

    private AwsCredentialsProvider getFromOptions(AwsCredentialsOptions awsCredentialsOptions) {
        DefaultCredentialsProvider awsCredentialsProvider;
        String awsStsRoleArn = awsCredentialsOptions.getStsRoleArn();
        if (awsStsRoleArn != null && !awsStsRoleArn.isEmpty()) {
            StsClient stsClient = (StsClient)((StsClientBuilder)StsClient.builder().region(awsCredentialsOptions.getRegion())).build();
            AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleSessionName("aws-iam-" + String.valueOf(UUID.randomUUID())).roleArn(awsStsRoleArn);
            awsCredentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)assumeRoleRequestBuilder.build()).build();
        } else {
            awsCredentialsProvider = DefaultCredentialsProvider.create();
        }
        return awsCredentialsProvider;
    }
}

