/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.opensearch.dataprepper.model.encryption.KeyProvider;
import org.opensearch.dataprepper.plugins.encryption.KmsEncryptionEngineConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;

class KmsKeyProvider
implements KeyProvider {
    static final Integer MAXIMUM_CACHED_KEYS = 5;
    private final KmsEncryptionEngineConfiguration kmsEncryptionEngineConfiguration;
    private final KmsClient kmsClient;
    private final Cache<byte[], byte[]> decryptedKeyCache = Caffeine.newBuilder().maximumSize((long)MAXIMUM_CACHED_KEYS.intValue()).build();

    public KmsKeyProvider(KmsEncryptionEngineConfiguration kmsEncryptionEngineConfiguration) {
        this.kmsClient = kmsEncryptionEngineConfiguration.createKmsClient();
        this.kmsEncryptionEngineConfiguration = kmsEncryptionEngineConfiguration;
    }

    public byte[] decryptKey(byte[] encryptionKey) {
        return this.decryptedKeyCache.asMap().computeIfAbsent(encryptionKey, key -> {
            String kmsKeyId = this.kmsEncryptionEngineConfiguration.getKeyId();
            DecryptRequest decryptRequest = (DecryptRequest)DecryptRequest.builder().keyId(kmsKeyId).ciphertextBlob(SdkBytes.fromByteArray((byte[])key)).encryptionContext(this.kmsEncryptionEngineConfiguration.getEncryptionContext()).build();
            DecryptResponse decryptResponse = this.kmsClient.decrypt(decryptRequest);
            return decryptResponse.plaintext().asByteArray();
        });
    }
}

