/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser.transformer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.stream.Stream;
import org.opensearch.dataprepper.pipeline.parser.rule.RuleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformersFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TransformersFactory.class);
    private static final String TEMPLATES_PATH = "org/opensearch/dataprepper/transforms/templates/";
    private static final String RULES_PATH = "org/opensearch/dataprepper/transforms/rules/";
    private final String TEMPLATE_FILE_NAME_PATTERN = "-template.yaml";
    private final String RULE_FILE_NAME_PATTERN = "-rule.yaml";

    public InputStream getPluginTemplateFileStream(String pluginName) {
        if (pluginName == null || pluginName.isEmpty()) {
            throw new RuntimeException("Transformation plugin not found");
        }
        String templateFileName = pluginName + "-template.yaml";
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL templateURL = classLoader.getResource(TEMPLATES_PATH + templateFileName);
        if (templateURL == null) {
            throw new RuntimeException("Template file not found for plugin: " + pluginName);
        }
        try {
            Path templatePath;
            try {
                templatePath = Paths.get(templateURL.toURI());
            }
            catch (FileSystemNotFoundException e) {
                FileSystem fileSystem = FileSystems.newFileSystem(templateURL.toURI(), Collections.emptyMap());
                templatePath = fileSystem.getPath(TEMPLATES_PATH + templateFileName, new String[0]);
            }
            return Files.newInputStream(templatePath, new OpenOption[0]);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Failed to load template file for plugin: " + pluginName, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<RuleStream> loadRules() {
        ArrayList<RuleStream> ruleStreams = new ArrayList<RuleStream>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Enumeration<URL> rulesURLs = classLoader.getResources(RULES_PATH);
            while (rulesURLs.hasMoreElements()) {
                URL rulesURL = rulesURLs.nextElement();
                try {
                    Path rulesPath;
                    try {
                        rulesPath = Paths.get(rulesURL.toURI());
                    }
                    catch (FileSystemNotFoundException e) {
                        FileSystem fileSystem = FileSystems.newFileSystem(rulesURL.toURI(), Collections.emptyMap());
                        rulesPath = fileSystem.getPath(RULES_PATH, new String[0]);
                    }
                    Stream<Path> paths = Files.walk(rulesPath, new FileVisitOption[0]);
                    try {
                        paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(rulePath -> {
                            try {
                                InputStream ruleInputStream = Files.newInputStream(rulePath, new OpenOption[0]);
                                ruleStreams.add(new RuleStream(rulePath.getFileName().toString(), ruleInputStream));
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed to load rule: " + String.valueOf(rulePath), e);
                            }
                        });
                    }
                    finally {
                        if (paths == null) continue;
                        paths.close();
                    }
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException("Failed to scan rules directory on classpath: " + String.valueOf(rulesURL), e);
                    return ruleStreams;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load rules from classpath.", e);
        }
    }
}

