/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser.transformer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.opensearch.dataprepper.model.configuration.PipelineModel;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;
import org.opensearch.dataprepper.model.configuration.SinkModel;
import org.opensearch.dataprepper.pipeline.parser.rule.RuleEvaluator;
import org.opensearch.dataprepper.pipeline.parser.rule.RuleEvaluatorResult;
import org.opensearch.dataprepper.pipeline.parser.transformer.PipelineConfigurationTransformer;
import org.opensearch.dataprepper.pipeline.parser.transformer.PipelineTemplateModel;
import org.opensearch.dataprepper.plugins.source.rds.utils.IdentifierShortener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;

public class DynamicConfigTransformer
implements PipelineConfigurationTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicConfigTransformer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final RuleEvaluator ruleEvaluator;
    private final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\<\\<\\s*(.+?)\\s*>>");
    private static final String PIPELINE_NAME_PLACEHOLDER_REGEX = "\\<\\<\\s*" + Pattern.quote("pipeline-name") + "\\s*\\>\\>";
    private static final String TEMPLATE_PIPELINE_ROOT_STRING = "templatePipelines";
    private static final String FUNCTION_CALL_PLACEHOLDER_REGEX = "FUNCTION_NAME:(.*?),PARAMETER:(.*)";
    private final Pattern FUNCTION_CALL_PLACEHOLDER_PATTERN = Pattern.compile("FUNCTION_NAME:(.*?),PARAMETER:(.*)");
    private static final String JSON_PATH_ARRAY_DISAMBIGUATOR_PATTERN = "[?(@.";
    private static final String RECURSIVE_JSON_PATH_PATH = "$..";
    private static final String JSON_PATH_IDENTIFIER = "$.";
    private static final String ARRAY_NODE_PATTERN = "([^\\[]+)\\[(\\d+)\\]$";
    private static final String SOURCE_COORDINATION_IDENTIFIER_ENVIRONMENT_VARIABLE = "SOURCE_COORDINATION_PIPELINE_IDENTIFIER";
    private static final String SINK_SUBPIPELINE_PLUGIN_NAME = "pipeline";
    private static final String SUBPIPELINE_PATH = "$.source.pipeline";
    private static final String S3_BUFFER_PREFIX = "/buffer";
    Configuration parseConfigWithJsonNode = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();

    public DynamicConfigTransformer(RuleEvaluator ruleEvaluator) {
        this.ruleEvaluator = ruleEvaluator;
    }

    @Override
    public PipelinesDataFlowModel transformConfiguration(PipelinesDataFlowModel preTransformedPipelinesDataFlowModel) {
        RuleEvaluatorResult ruleEvaluatorResult = this.ruleEvaluator.isTransformationNeeded(preTransformedPipelinesDataFlowModel);
        if (!ruleEvaluatorResult.isEvaluatedResult() || ruleEvaluatorResult.getPipelineName() == null) {
            LOG.info("No transformation needed");
            return preTransformedPipelinesDataFlowModel;
        }
        String pipelineNameThatNeedsTransformation = ruleEvaluatorResult.getPipelineName();
        PipelineTemplateModel templateModel = ruleEvaluatorResult.getPipelineTemplateModel();
        LOG.info("Transforming pipeline config for pipeline {}", (Object)pipelineNameThatNeedsTransformation);
        try {
            Map pipelines = preTransformedPipelinesDataFlowModel.getPipelines();
            ArrayList<String> subPipelineNames = new ArrayList<String>();
            this.checkForSubPipelines(preTransformedPipelinesDataFlowModel, pipelineNameThatNeedsTransformation, subPipelineNames);
            HashMap<String, PipelineModel> pipelineMap = new HashMap<String, PipelineModel>();
            pipelineMap.put(pipelineNameThatNeedsTransformation, (PipelineModel)pipelines.get(pipelineNameThatNeedsTransformation));
            String pipelineJson = this.objectMapper.writeValueAsString(pipelineMap);
            String templateJsonStringWithPipelinePlaceholder = this.objectMapper.writeValueAsString((Object)templateModel);
            String templateJsonString = this.replaceTemplatePipelineName(templateJsonStringWithPipelinePlaceholder, pipelineNameThatNeedsTransformation);
            LOG.info("Template - {}", (Object)templateJsonString);
            Map<String, List<String>> placeholdersMap = this.findPlaceholdersWithPathsRecursively(templateJsonString);
            JsonNode templateRootNode = this.objectMapper.readTree(templateJsonString);
            Map<String, String> pipelineExactPathMap = this.findExactPath(placeholdersMap, pipelineJson);
            placeholdersMap.forEach((placeholder, templateJsonPathList) -> {
                for (String templateJsonPath : templateJsonPathList) {
                    JsonNode pipelineNode;
                    String pipelineExactJsonPath = (String)pipelineExactPathMap.get(placeholder);
                    if (this.isJsonPath(pipelineExactJsonPath)) {
                        pipelineNode = (JsonNode)JsonPath.using((Configuration)this.parseConfigWithJsonNode).parse(pipelineJson).read(pipelineExactJsonPath, new Predicate[0]);
                        if (pipelineExactJsonPath.contains(JSON_PATH_ARRAY_DISAMBIGUATOR_PATTERN) && pipelineNode.isArray() && pipelineNode.size() == 1) {
                            pipelineNode = pipelineNode.get(0);
                        }
                        this.replaceNode(templateRootNode, templateJsonPath, pipelineNode);
                        continue;
                    }
                    pipelineNode = this.objectMapper.valueToTree((Object)pipelineExactJsonPath);
                    this.replaceNode(templateRootNode, templateJsonPath, pipelineNode);
                }
            });
            PipelinesDataFlowModel transformedPipelinesDataFlowModel = this.getTransformedPipelinesDataFlowModel(pipelineNameThatNeedsTransformation, preTransformedPipelinesDataFlowModel, templateRootNode, subPipelineNames);
            return transformedPipelinesDataFlowModel;
        }
        catch (JsonProcessingException | TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkForSubPipelines(PipelinesDataFlowModel preTransformedPipelinesDataFlowModel, String pipelineNameThatNeedsTransformation, List<String> subPipelineNames) {
        Map pipelines = preTransformedPipelinesDataFlowModel.getPipelines();
        PipelineModel transformationPipeline = (PipelineModel)pipelines.get(pipelineNameThatNeedsTransformation);
        List sinks = transformationPipeline.getSinks();
        for (SinkModel sink : sinks) {
            String pluginName = sink.getPluginName();
            if (!pluginName.equals(SINK_SUBPIPELINE_PLUGIN_NAME)) continue;
            String subPipelineName = sink.getPluginSettings().get("name").toString();
            subPipelineNames.add(subPipelineName);
        }
    }

    private PipelinesDataFlowModel getTransformedPipelinesDataFlowModel(String pipelineNameThatNeedsTransformation, PipelinesDataFlowModel preTransformedPipelinesDataFlowModel, JsonNode templateRootNode, List<String> subPipelineNames) throws JsonProcessingException {
        JsonNode transformedJsonNode = templateRootNode.get(TEMPLATE_PIPELINE_ROOT_STRING);
        String transformedJson = this.objectMapper.writeValueAsString((Object)transformedJsonNode);
        LOG.info("{} pipeline has been transformed to :{}", (Object)pipelineNameThatNeedsTransformation, (Object)transformedJson);
        PipelinesDataFlowModel transformedSinglePipelineDataFlowModel = (PipelinesDataFlowModel)this.objectMapper.readValue(transformedJson, PipelinesDataFlowModel.class);
        Map transformedPipelines = transformedSinglePipelineDataFlowModel.getPipelines();
        Map pipelines = preTransformedPipelinesDataFlowModel.getPipelines();
        pipelines.forEach((pipelineName, pipeline) -> {
            if (!pipelineName.equals(pipelineNameThatNeedsTransformation)) {
                if (subPipelineNames.size() > 0 && subPipelineNames.contains(pipelineName)) {
                    try {
                        PipelineModel subPipeline = this.getSubModifiedPipeline((PipelineModel)pipeline, pipelineNameThatNeedsTransformation);
                        transformedPipelines.put(pipelineName, subPipeline);
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    transformedPipelines.put(pipelineName, pipeline);
                }
            }
        });
        PipelinesDataFlowModel transformedPipelinesDataFlowModel = new PipelinesDataFlowModel(preTransformedPipelinesDataFlowModel.getPipelineExtensions(), transformedPipelines);
        String transformedPipelinesDataFlowModelJson = this.objectMapper.writeValueAsString((Object)transformedPipelinesDataFlowModel);
        LOG.info("Transformed PipelinesDataFlowModel: {}", (Object)transformedPipelinesDataFlowModelJson);
        return transformedPipelinesDataFlowModel;
    }

    private PipelineModel getSubModifiedPipeline(PipelineModel pipeline, String pipelineNameThatNeedsTransformation) throws JsonProcessingException {
        String pipelineJson = this.objectMapper.writeValueAsString((Object)pipeline);
        JsonNode pipelineNode = this.objectMapper.readTree(pipelineJson);
        JsonNode parentNode = (JsonNode)JsonPath.using((Configuration)this.parseConfigWithJsonNode).parse((Object)pipelineNode).read(SUBPIPELINE_PATH, new Predicate[0]);
        TextNode newNode = new TextNode(pipelineNameThatNeedsTransformation + "-s3");
        ((ObjectNode)parentNode).replace("name", (JsonNode)newNode);
        String subPipelineJson = this.objectMapper.writeValueAsString((Object)pipelineNode);
        PipelineModel subPipeline = (PipelineModel)this.objectMapper.readValue(subPipelineJson, PipelineModel.class);
        return subPipeline;
    }

    private String replaceTemplatePipelineName(String templateJsonStringWithPipelinePlaceholder, String pipelineName) {
        return templateJsonStringWithPipelinePlaceholder.replaceAll(PIPELINE_NAME_PLACEHOLDER_REGEX, pipelineName);
    }

    private Map<String, List<String>> findPlaceholdersWithPathsRecursively(String json) throws IOException {
        JsonNode rootNode = this.objectMapper.readTree(json);
        HashMap<String, List<String>> placeholdersWithPaths = new HashMap<String, List<String>>();
        this.populateMapWithPlaceholderPaths(rootNode, "", placeholdersWithPaths);
        return placeholdersWithPaths;
    }

    private void populateMapWithPlaceholderPaths(JsonNode currentNode, String currentPath, Map<String, List<String>> placeholdersWithPaths) {
        String placeHolderValue;
        Matcher matcher;
        if (currentNode.isObject()) {
            Iterator fields = currentNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String path = currentPath.isEmpty() ? (String)entry.getKey() : currentPath + "." + (String)entry.getKey();
                this.populateMapWithPlaceholderPaths((JsonNode)entry.getValue(), path, placeholdersWithPaths);
            }
        } else if (currentNode.isArray()) {
            for (int i = 0; i < currentNode.size(); ++i) {
                String path = currentPath + "[" + i + "]";
                this.populateMapWithPlaceholderPaths(currentNode.get(i), path, placeholdersWithPaths);
            }
        } else if (currentNode.isValueNode() && (matcher = this.PLACEHOLDER_PATTERN.matcher(placeHolderValue = currentNode.asText())).find()) {
            if (!placeholdersWithPaths.containsKey(placeHolderValue)) {
                ArrayList<String> paths = new ArrayList<String>();
                paths.add(currentPath);
                placeholdersWithPaths.put(placeHolderValue, paths);
            } else {
                List<String> existingPaths = placeholdersWithPaths.get(placeHolderValue);
                existingPaths.add(currentPath);
                placeholdersWithPaths.put(placeHolderValue, existingPaths);
            }
        }
    }

    private Map<String, String> findExactPath(Map<String, List<String>> placeholdersMap, String pipelineJson) throws IOException, TransformerException {
        HashMap<String, String> mapWithPaths = new HashMap<String, String>();
        for (String genericPathPlaceholder : placeholdersMap.keySet()) {
            String placeHolderValue = this.getValueFromPlaceHolder(genericPathPlaceholder);
            String value = this.executeFunctionPlaceholder(placeHolderValue, pipelineJson);
            if (value != null && value.contains(RECURSIVE_JSON_PATH_PATH)) {
                throw new TransformerException(String.format("Json path {} is not supported", value));
            }
            mapWithPaths.put(genericPathPlaceholder, value);
        }
        return mapWithPaths;
    }

    private String getValueFromPlaceHolder(String placeholder) {
        return placeholder.substring(2, placeholder.length() - 2);
    }

    private String executeFunctionPlaceholder(String functionPlaceholderValue, String pipelineJson) {
        Matcher functionMatcher = this.FUNCTION_CALL_PLACEHOLDER_PATTERN.matcher(functionPlaceholderValue);
        if (functionMatcher.find()) {
            String functionName = functionMatcher.group(1);
            String parameter = functionMatcher.group(2);
            try {
                String parameterValue = (String)this.parseParameter(parameter, pipelineJson);
                String value = (String)this.invokeMethod(functionName, String.class, parameterValue);
                return value;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return functionPlaceholderValue;
    }

    private Object parseParameter(String parameter, String pipelineJson) {
        if (this.isJsonPath(parameter)) {
            JsonNode pipelineNode = (JsonNode)JsonPath.using((Configuration)this.parseConfigWithJsonNode).parse(pipelineJson).read(parameter, new Predicate[0]);
            if (pipelineNode == null) {
                return null;
            }
            if (!pipelineNode.isValueNode()) {
                throw new RuntimeException("parameter has to be a value node");
            }
            String nodeValue = pipelineNode.asText();
            return nodeValue;
        }
        return parameter;
    }

    private boolean isJsonPath(String parameter) {
        try {
            if (parameter == null) {
                return false;
            }
            if (parameter.contains(JSON_PATH_IDENTIFIER)) {
                JsonPath.compile((String)parameter, (Predicate[])new Predicate[0]);
                return true;
            }
            return false;
        }
        catch (PathNotFoundException | IllegalArgumentException e) {
            return false;
        }
    }

    public String calculateDepth(String s3Prefix) {
        return Integer.toString(this.getDepth(s3Prefix, 4));
    }

    public String calculateDepthForRdsSource(String s3Prefix) {
        return Integer.toString(this.getDepth(s3Prefix, 3));
    }

    private int getDepth(String s3Prefix, int baseDepth) {
        if (s3Prefix == null) {
            return baseDepth;
        }
        return s3Prefix.split("/").length + baseDepth;
    }

    public String getSourceCoordinationIdentifierEnvVariable(String s3Prefix) {
        String envSourceCoordinationIdentifier = System.getenv(SOURCE_COORDINATION_IDENTIFIER_ENVIRONMENT_VARIABLE);
        if (s3Prefix == null) {
            return envSourceCoordinationIdentifier;
        }
        return s3Prefix + "/" + envSourceCoordinationIdentifier;
    }

    public String getIncludePrefixForRdsSource(String s3Prefix) {
        String shortenedSourceIdentifier;
        String envSourceCoordinationIdentifier = System.getenv(SOURCE_COORDINATION_IDENTIFIER_ENVIRONMENT_VARIABLE);
        String string = shortenedSourceIdentifier = envSourceCoordinationIdentifier != null ? IdentifierShortener.shortenIdentifier((String)envSourceCoordinationIdentifier, (int)15) : null;
        if (s3Prefix == null && envSourceCoordinationIdentifier == null) {
            return S3_BUFFER_PREFIX;
        }
        if (s3Prefix == null) {
            return shortenedSourceIdentifier + S3_BUFFER_PREFIX;
        }
        if (envSourceCoordinationIdentifier == null) {
            return s3Prefix + S3_BUFFER_PREFIX;
        }
        return s3Prefix + "/" + shortenedSourceIdentifier + S3_BUFFER_PREFIX;
    }

    public String getAccountIdFromRole(String roleArn) {
        if (roleArn == null) {
            return null;
        }
        try {
            return Arn.fromString((String)roleArn).accountId().orElse(null);
        }
        catch (Exception e) {
            LOG.warn("Malformatted role ARN for dynamic transformation: {}", (Object)roleArn);
            return null;
        }
    }

    public Object invokeMethod(String methodName, Class<?> parameterType, Object arg) throws ReflectiveOperationException {
        Class<?> clazz = this.getClass();
        Method method = clazz.getMethod(methodName, parameterType);
        return method.invoke((Object)this, arg);
    }

    public void replaceNode(JsonNode root, String jsonPath, JsonNode newNode) {
        block6: {
            try {
                if (newNode == null) {
                    LOG.info("Did not find jsonPath {}", (Object)jsonPath);
                }
                String parentPath = jsonPath.substring(0, jsonPath.lastIndexOf(46));
                String fieldName = jsonPath.substring(jsonPath.lastIndexOf(46) + 1);
                Pattern pattern = Pattern.compile(ARRAY_NODE_PATTERN);
                Matcher matcher = pattern.matcher(fieldName);
                JsonNode parentNode = (JsonNode)JsonPath.using((Configuration)this.parseConfigWithJsonNode).parse((Object)root).read(parentPath, new Predicate[0]);
                if (matcher.find()) {
                    String field = matcher.group(1);
                    int index = Integer.parseInt(matcher.group(2));
                    JsonNode arrayNodeResult = (JsonNode)JsonPath.using((Configuration)this.parseConfigWithJsonNode).parse((Object)root).read(parentPath + "." + field, new Predicate[0]);
                    if (!(arrayNodeResult instanceof ArrayNode)) {
                        throw new RuntimeException("Json path is of array type, but parsed result is not arrayNode");
                    }
                    ArrayNode arrayNode = (ArrayNode)arrayNodeResult;
                    arrayNode.set(index, newNode);
                    break block6;
                }
                if (parentNode != null && parentNode instanceof ObjectNode) {
                    ((ObjectNode)parentNode).replace(fieldName, newNode);
                    break block6;
                }
                LOG.error("Path does not point to object node");
                throw new IllegalArgumentException("Path does not point to object node");
            }
            catch (PathNotFoundException e) {
                LOG.error("JsonPath {} not found", (Object)jsonPath);
                throw new PathNotFoundException(String.format("JsonPath {} not found", jsonPath));
            }
        }
    }
}

