/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.dataprepper.pipeline.parser.ParseException;
import org.opensearch.dataprepper.pipeline.parser.PipelineConfigurationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineConfigurationFileReader
implements PipelineConfigurationReader {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineConfigurationFileReader.class);
    private final String pipelineConfigurationFileLocation;

    public PipelineConfigurationFileReader(String pipelineConfigurationFileLocation) {
        this.pipelineConfigurationFileLocation = pipelineConfigurationFileLocation;
    }

    @Override
    public List<InputStream> getPipelineConfigurationInputStreams() {
        return this.getInputStreamsForConfigurationFiles();
    }

    private List<InputStream> getInputStreamsForConfigurationFiles() {
        File configurationLocation = new File(this.pipelineConfigurationFileLocation);
        if (configurationLocation.isFile()) {
            List<InputStream> inputStreams = Stream.of(configurationLocation).map(this::getInputStreamForFile).filter(Objects::nonNull).collect(Collectors.toList());
            if (inputStreams.size() != 1) {
                throw new ParseException(String.format("Pipeline configuration file not loadable at %s", configurationLocation.getName()));
            }
            return inputStreams;
        }
        if (configurationLocation.isDirectory()) {
            FileFilter yamlFilter = pathname -> pathname.getName().endsWith(".yaml") || pathname.getName().endsWith(".yml");
            List<InputStream> inputStreams = Stream.of(configurationLocation.listFiles(yamlFilter)).map(this::getInputStreamForFile).filter(Objects::nonNull).collect(Collectors.toList());
            if (inputStreams.isEmpty()) {
                LOG.error("Pipelines configuration file not found at {}", (Object)this.pipelineConfigurationFileLocation);
                throw new ParseException(String.format("Pipelines configuration file not found at %s", this.pipelineConfigurationFileLocation));
            }
            return inputStreams;
        }
        LOG.error("Pipelines configuration file not found at {}", (Object)this.pipelineConfigurationFileLocation);
        throw new ParseException(String.format("Pipelines configuration file not found at %s", this.pipelineConfigurationFileLocation));
    }

    private InputStream getInputStreamForFile(File pipelineConfigurationFile) {
        try {
            return new FileInputStream(pipelineConfigurationFile);
        }
        catch (IOException e) {
            LOG.warn("Unable to load pipeline configuration file {}", (Object)pipelineConfigurationFile.getName());
            return null;
        }
    }
}

