/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataPrepperDurationParser {
    private static final String SIMPLE_DURATION_REGEX = "^(0|[1-9]\\d*)(s|ms)$";
    private static final Pattern SIMPLE_DURATION_PATTERN = Pattern.compile("^(0|[1-9]\\d*)(s|ms)$");
    private static final String INVALID_DURATION_ERROR_MESSAGE = "Durations must use either ISO 8601 notation or simple notations for seconds (60s) or milliseconds (100ms). Whitespace is ignored.";

    public static Duration parse(String durationString) {
        if (durationString == null) {
            throw new IllegalArgumentException(INVALID_DURATION_ERROR_MESSAGE);
        }
        try {
            return Duration.parse(durationString);
        }
        catch (DateTimeParseException e) {
            Duration duration = DataPrepperDurationParser.parseSimpleDuration(durationString);
            if (duration == null) {
                throw new IllegalArgumentException(INVALID_DURATION_ERROR_MESSAGE);
            }
            return duration;
        }
    }

    private static Duration parseSimpleDuration(String durationString) throws IllegalArgumentException {
        String durationStringNoSpaces = durationString.replaceAll("\\s", "");
        Matcher matcher = SIMPLE_DURATION_PATTERN.matcher(durationStringNoSpaces);
        if (!matcher.find()) {
            return null;
        }
        long durationNumber = Long.parseLong(matcher.group(1));
        String durationUnit = matcher.group(2);
        return DataPrepperDurationParser.getDurationFromUnitAndNumber(durationNumber, durationUnit);
    }

    private static Duration getDurationFromUnitAndNumber(long durationNumber, String durationUnit) {
        switch (durationUnit) {
            case "s": {
                return Duration.ofSeconds(durationNumber);
            }
            case "ms": {
                return Duration.ofMillis(durationNumber);
            }
        }
        return null;
    }
}

