/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.keyvalue;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opensearch.dataprepper.common.TransformOption;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.keyvalue.KeyValueProcessorConfig;
import org.opensearch.dataprepper.plugins.processor.keyvalue.WhitespaceOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="key_value", pluginType=Processor.class, pluginConfigurationType=KeyValueProcessorConfig.class)
public class KeyValueProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueProcessor.class);
    private static String[] startGroupStrings = new String[]{"\"", "'", "(", "[", "<", "{", "http://", "https://"};
    private static Character[] endGroupChars = new Character[]{Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('>'), Character.valueOf('}'), Character.valueOf(' '), Character.valueOf(' ')};
    private final KeyValueProcessorConfig keyValueProcessorConfig;
    private final ExpressionEvaluator expressionEvaluator;
    private final Pattern fieldDelimiterPattern;
    private final Pattern keyValueDelimiterPattern;
    private final Set<String> includeKeysSet = new HashSet<String>();
    private final Set<String> excludeKeysSet = new HashSet<String>();
    private final HashMap<String, Object> defaultValuesMap = new HashMap();
    private final Set<String> defaultValuesSet = new HashSet<String>();
    private final String whitespaceStrict = "strict";
    private final String whitespaceLenient = "lenient";
    private final Set<String> validWhitespaceSet = Set.of("lenient", "strict");
    final String delimiterBracketCheck = "[\\[\\]()<>]";
    private final Set<Character> bracketSet = Set.of(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'));
    private final List<String> tagsOnFailure;
    private final Character stringLiteralCharacter;
    private final String keyPrefix;
    private final boolean normalizeKeys;

    @DataPrepperPluginConstructor
    public KeyValueProcessor(PluginMetrics pluginMetrics, KeyValueProcessorConfig keyValueProcessorConfig, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        String regex;
        this.keyValueProcessorConfig = keyValueProcessorConfig;
        this.stringLiteralCharacter = keyValueProcessorConfig.getStringLiteralCharacter();
        this.tagsOnFailure = keyValueProcessorConfig.getTagsOnFailure();
        this.normalizeKeys = keyValueProcessorConfig.getNormalizeKeys();
        if (keyValueProcessorConfig.getFieldDelimiterRegex() != null && !keyValueProcessorConfig.getFieldDelimiterRegex().isEmpty()) {
            if (keyValueProcessorConfig.getFieldSplitCharacters() != null && !keyValueProcessorConfig.getFieldSplitCharacters().isEmpty()) {
                throw new IllegalArgumentException("field_delimiter_regex and field_split_characters cannot both be defined.");
            }
            if (!this.validateRegex(keyValueProcessorConfig.getFieldDelimiterRegex())) {
                throw new PatternSyntaxException("field_delimiter_regex is not a valid regex string", keyValueProcessorConfig.getFieldDelimiterRegex(), -1);
            }
            this.fieldDelimiterPattern = Pattern.compile(keyValueProcessorConfig.getFieldDelimiterRegex());
            if (keyValueProcessorConfig.getRecursive() && this.fieldDelimiterPattern.matcher("[\\[\\]()<>]").matches()) {
                throw new IllegalArgumentException("While recursive is true, the set field delimiter regex cannot contain brackets while you are trying to recurse.");
            }
        } else {
            if (keyValueProcessorConfig.getFieldSplitCharacters().isEmpty()) {
                regex = "&";
            } else {
                if (keyValueProcessorConfig.getRecursive() && keyValueProcessorConfig.getFieldSplitCharacters().length() != 1) {
                    throw new IllegalArgumentException("While recursive is true, the set field split characters is limited to one character only.");
                }
                regex = this.buildRegexFromCharacters(keyValueProcessorConfig.getFieldSplitCharacters());
            }
            this.fieldDelimiterPattern = Pattern.compile(regex);
            if (keyValueProcessorConfig.getRecursive() && this.fieldDelimiterPattern.matcher("[\\[\\]()<>]").matches()) {
                throw new IllegalArgumentException("While recursive is true, the set field delimiter cannot contain brackets while you are trying to recurse.");
            }
        }
        if (keyValueProcessorConfig.getKeyValueDelimiterRegex() != null && !keyValueProcessorConfig.getKeyValueDelimiterRegex().isEmpty()) {
            if (keyValueProcessorConfig.getValueSplitCharacters() != null && !keyValueProcessorConfig.getValueSplitCharacters().isEmpty()) {
                throw new IllegalArgumentException("key_value_delimiter_regex and value_split_characters cannot both be defined.");
            }
            if (!this.validateRegex(keyValueProcessorConfig.getKeyValueDelimiterRegex())) {
                throw new PatternSyntaxException("key_value_delimiter_regex is not a valid regex string", keyValueProcessorConfig.getKeyValueDelimiterRegex(), -1);
            }
            this.keyValueDelimiterPattern = Pattern.compile(keyValueProcessorConfig.getKeyValueDelimiterRegex());
            if (keyValueProcessorConfig.getRecursive() && this.keyValueDelimiterPattern.matcher("[\\[\\]()<>]").matches()) {
                throw new IllegalArgumentException("While recursive is true, the set key value delimiter regex cannot contain brackets while you are trying to recurse.");
            }
        } else {
            if (keyValueProcessorConfig.getValueSplitCharacters().isEmpty()) {
                regex = "=";
            } else {
                if (keyValueProcessorConfig.getRecursive() && keyValueProcessorConfig.getValueSplitCharacters().length() != 1) {
                    throw new IllegalArgumentException("While recursive is true, the set value split characters is limited to one character only.");
                }
                regex = this.buildRegexFromCharacters(keyValueProcessorConfig.getValueSplitCharacters());
            }
            this.keyValueDelimiterPattern = Pattern.compile(regex);
            if (keyValueProcessorConfig.getRecursive() && this.keyValueDelimiterPattern.matcher("[\\[\\]()<>]").matches()) {
                throw new IllegalArgumentException("While recursive is true, the set value split characters cannot contain brackets while you are trying to recurse.");
            }
        }
        if (!this.validateRegex(keyValueProcessorConfig.getDeleteKeyRegex())) {
            throw new PatternSyntaxException("delete_key_regex is not a valid regex string", keyValueProcessorConfig.getDeleteKeyRegex(), -1);
        }
        if (!this.validateRegex(keyValueProcessorConfig.getDeleteValueRegex())) {
            throw new PatternSyntaxException("delete_value_regex is not a valid regex string", keyValueProcessorConfig.getDeleteValueRegex(), -1);
        }
        this.includeKeysSet.addAll(keyValueProcessorConfig.getIncludeKeys());
        this.excludeKeysSet.addAll(keyValueProcessorConfig.getExcludeKeys());
        this.defaultValuesMap.putAll(keyValueProcessorConfig.getDefaultValues());
        if (!this.defaultValuesMap.isEmpty()) {
            this.defaultValuesSet.addAll(this.defaultValuesMap.keySet());
        }
        this.validateKeySets(this.includeKeysSet, this.excludeKeysSet, this.defaultValuesSet);
        Pattern boolCheck = Pattern.compile("true|false", 2);
        Matcher duplicateValueBoolMatch = boolCheck.matcher(String.valueOf(keyValueProcessorConfig.getSkipDuplicateValues()));
        Matcher removeBracketsBoolMatch = boolCheck.matcher(String.valueOf(keyValueProcessorConfig.getRemoveBrackets()));
        Matcher recursiveBoolMatch = boolCheck.matcher(String.valueOf(keyValueProcessorConfig.getRecursive()));
        if (!duplicateValueBoolMatch.matches()) {
            throw new IllegalArgumentException(String.format("The skip_duplicate_values value must be either true or false", keyValueProcessorConfig.getSkipDuplicateValues()));
        }
        if (!removeBracketsBoolMatch.matches()) {
            throw new IllegalArgumentException(String.format("The remove_brackets value must be either true or false", keyValueProcessorConfig.getRemoveBrackets()));
        }
        if (!recursiveBoolMatch.matches()) {
            throw new IllegalArgumentException(String.format("The recursive value must be either true or false", keyValueProcessorConfig.getRemoveBrackets()));
        }
        if (keyValueProcessorConfig.getRemoveBrackets() && keyValueProcessorConfig.getRecursive()) {
            throw new IllegalArgumentException("Cannot remove brackets needed for determining levels of recursion");
        }
        this.expressionEvaluator = expressionEvaluator;
        if (keyValueProcessorConfig.getKeyValueWhen() != null && !expressionEvaluator.isValidExpressionStatement(keyValueProcessorConfig.getKeyValueWhen()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("key_value_when %s is not a valid expression statement", keyValueProcessorConfig.getKeyValueWhen()));
        }
        this.keyPrefix = keyValueProcessorConfig.getPrefix() != null ? keyValueProcessorConfig.getPrefix() : "";
    }

    private String buildRegexFromCharacters(String s) {
        char[] splitters = s.toCharArray();
        StringBuilder regexedFieldSplitCharacters = new StringBuilder();
        for (char c : splitters) {
            if (Objects.equals(Character.valueOf(c), Character.valueOf('\\'))) {
                regexedFieldSplitCharacters.append(c);
                continue;
            }
            regexedFieldSplitCharacters.append(c).append('|');
        }
        regexedFieldSplitCharacters = new StringBuilder(regexedFieldSplitCharacters.substring(0, regexedFieldSplitCharacters.length() - 1));
        return regexedFieldSplitCharacters.toString();
    }

    private boolean validateRegex(String pattern) {
        if (pattern != null && !Objects.equals(pattern, "")) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }
        return true;
    }

    private void validateKeySets(Set<String> includeSet, Set<String> excludeSet, Set<String> defaultSet) {
        HashSet<String> includeIntersectionSet = new HashSet<String>(includeSet);
        HashSet<String> defaultIntersectionSet = new HashSet<String>(defaultSet);
        includeIntersectionSet.retainAll(excludeSet);
        if (!includeIntersectionSet.isEmpty()) {
            throw new IllegalArgumentException("Include keys and exclude keys set cannot have any overlap");
        }
        defaultIntersectionSet.retainAll(excludeSet);
        if (!defaultIntersectionSet.isEmpty()) {
            throw new IllegalArgumentException("Cannot exclude a default key!");
        }
    }

    private boolean isEscapedQuote(String str, int idx) {
        return idx > 0 && (str.charAt(idx) == '\"' || str.charAt(idx) == '\'') && str.charAt(idx - 1) == '\\';
    }

    public int skipGroup(String str, int idx, Character endChar) {
        int i = idx;
        while (i < str.length()) {
            if (this.isEscapedQuote(str, i)) {
                ++i;
                continue;
            }
            if (str.charAt(i) == endChar.charValue()) {
                return i;
            }
            ++i;
        }
        if (this.keyValueProcessorConfig.isStrictGroupingEnabled()) {
            throw new RuntimeException("Bad Input, no end character found in " + str + " after index " + idx + ", expected end char = " + endChar);
        }
        return i - 1;
    }

    private void addPart(List<String> parts, String str, int start, int end) {
        String part = str.substring(start, end).trim();
        if (part.length() > 0) {
            parts.add(part);
        }
    }

    private int findInStartGroup(String str, int idx) {
        if (idx < 0 || idx >= str.length()) {
            return -1;
        }
        for (int j = 0; j < startGroupStrings.length; ++j) {
            String startGroup = startGroupStrings[j];
            int startGroupLen = startGroup.length();
            if (idx + startGroupLen > str.length() || !str.startsWith(startGroup, idx)) continue;
            if (j <= 1 && (idx == 0 || str.charAt(idx - 1) != '\\')) {
                return j;
            }
            if (j <= 1) continue;
            return j;
        }
        return -1;
    }

    private List<String> parseWithValueGrouping(String str) {
        int i;
        String fieldDelimiter = this.keyValueProcessorConfig.getFieldSplitCharacters();
        HashSet<Character> fieldDelimiterSet = new HashSet<Character>();
        for (char ch : fieldDelimiter.toCharArray()) {
            fieldDelimiterSet.add(Character.valueOf(ch));
        }
        int start = i = 0;
        ArrayList<String> parts = new ArrayList<String>();
        while (i < str.length()) {
            String[] s;
            if (this.isEscapedQuote(str, i)) {
                ++i;
                continue;
            }
            int groupIndex = this.findInStartGroup(str, i);
            boolean skippedGroup = false;
            if (groupIndex >= 0 && ((s = this.keyValueDelimiterPattern.split(str.substring(start, i + 1))).length > 1 || this.stringLiteralCharacter != null && startGroupStrings[groupIndex].charAt(0) == this.stringLiteralCharacter.charValue())) {
                i = this.skipGroup(str, i + 1, endGroupChars[groupIndex]);
                skippedGroup = true;
            }
            if (fieldDelimiterSet.contains(Character.valueOf(str.charAt(i)))) {
                if (skippedGroup) {
                    ++i;
                }
                this.addPart(parts, str, start, i);
                start = ++i;
                continue;
            }
            ++i;
        }
        if (start != i) {
            this.addPart(parts, str, start, i);
        }
        return parts;
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        ObjectMapper mapper = new ObjectMapper();
        for (Record<Event> record : records) {
            HashMap<String, Object> outputMap = new HashMap<String, Object>();
            Event recordEvent = (Event)record.getData();
            try {
                String groupsRaw;
                if (this.keyValueProcessorConfig.getKeyValueWhen() != null && !this.expressionEvaluator.evaluateConditional(this.keyValueProcessorConfig.getKeyValueWhen(), recordEvent).booleanValue() || (groupsRaw = (String)recordEvent.get(this.keyValueProcessorConfig.getSource(), String.class)) == null) continue;
                String[] groups = this.keyValueProcessorConfig.getValueGrouping() ? (String[])this.parseWithValueGrouping(groupsRaw).stream().toArray(String[]::new) : this.fieldDelimiterPattern.split(groupsRaw, 0);
                if (this.keyValueProcessorConfig.getRecursive()) {
                    try {
                        ObjectNode recursedTree = this.recurse(groupsRaw, mapper);
                        outputMap.putAll(this.createRecursedMap((JsonNode)recursedTree, mapper));
                    }
                    catch (Exception e) {
                        LOG.error("Recursive parsing ran into an unexpected error, treating message as non-recursive", (Throwable)e);
                        recordEvent.getMetadata().addTags(this.tagsOnFailure);
                    }
                } else {
                    try {
                        outputMap.putAll(this.createNonRecursedMap(groups));
                    }
                    catch (Exception e) {
                        LOG.error("Non-recursive parsing ran into an unexpected error", (Throwable)e);
                        recordEvent.getMetadata().addTags(this.tagsOnFailure);
                    }
                }
                Map<String, Object> processedMap = this.executeConfigs(outputMap);
                if (Objects.isNull(this.keyValueProcessorConfig.getDestination())) {
                    this.writeToRoot(recordEvent, processedMap);
                    continue;
                }
                if (!this.keyValueProcessorConfig.getOverwriteIfDestinationExists() && recordEvent.containsKey(this.keyValueProcessorConfig.getDestination())) continue;
                recordEvent.put(this.keyValueProcessorConfig.getDestination(), processedMap, this.normalizeKeys);
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.EVENT, "There was an exception while processing on Event [{}]: ", (Object)recordEvent, (Object)e);
                recordEvent.getMetadata().addTags(this.tagsOnFailure);
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private ObjectNode recurse(String input, ObjectMapper mapper) {
        Stack<Character> bracketStack = new Stack<Character>();
        Map<Character, Character> bracketMap = KeyValueProcessor.initBracketMap();
        int pairStart = 0;
        ArrayList<String> pairs = new ArrayList<String>();
        ObjectNode root = mapper.createObjectNode();
        for (int i = 0; i < input.length(); ++i) {
            if (bracketMap.containsKey(Character.valueOf(input.charAt(i)))) {
                bracketStack.push(Character.valueOf(input.charAt(i)));
            }
            if (bracketMap.containsValue(Character.valueOf(input.charAt(i))) && !bracketStack.isEmpty() && bracketMap.get(bracketStack.peek()).charValue() == input.charAt(i)) {
                bracketStack.pop();
            }
            if (!bracketStack.isEmpty() || !this.fieldDelimiterPattern.matcher(String.valueOf(input.charAt(i))).matches()) continue;
            String pair = input.substring(pairStart, i);
            pairs.add(pair);
            pairStart = i + 1;
        }
        pairs.add(input.substring(pairStart));
        for (String pair : pairs) {
            String valueString;
            int keyStart = 0;
            int keyEnd = -1;
            int valueStart = -1;
            int valueEnd = -1;
            String keyString = "";
            Character whitespaceChar = Character.valueOf(' ');
            bracketStack.clear();
            for (int i = 0; i < pair.length(); ++i) {
                if (!bracketStack.isEmpty() || !this.keyValueDelimiterPattern.matcher(String.valueOf(pair.charAt(i))).matches()) continue;
                keyString = pair.substring(keyStart, i).stripTrailing();
                valueStart = i + 1;
                while (pair.charAt(valueStart) == whitespaceChar.charValue()) {
                    ++valueStart;
                }
                break;
            }
            if (keyString.isBlank()) {
                keyString = pair;
                LOG.debug("Unsuccessful match: '{}'", (Object)keyString);
                valueString = this.keyValueProcessorConfig.getNonMatchValue().toString().stripLeading();
                continue;
            }
            if (bracketMap.containsKey(Character.valueOf(pair.charAt(valueStart)))) {
                if (pair.charAt(pair.length() - 1) != bracketMap.get(Character.valueOf(pair.charAt(valueStart))).charValue()) continue;
                valueEnd = pair.length() - 1;
                valueString = pair.substring(++valueStart, valueEnd).stripLeading();
                JsonNode jsonNode = root.put(keyString, (JsonNode)this.recurse(valueString, mapper));
                continue;
            }
            valueString = pair.substring(valueStart).stripLeading();
            ObjectNode objectNode = root.put(keyString, valueString);
        }
        return root;
    }

    private static Map<Character, Character> initBracketMap() {
        HashMap<Character, Character> bracketMap = new HashMap<Character, Character>();
        bracketMap.put(Character.valueOf('['), Character.valueOf(']'));
        bracketMap.put(Character.valueOf('('), Character.valueOf(')'));
        bracketMap.put(Character.valueOf('<'), Character.valueOf('>'));
        return bracketMap;
    }

    private Map<String, Object> createRecursedMap(JsonNode node, ObjectMapper mapper) {
        return (Map)mapper.convertValue((Object)node, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
    }

    private boolean isIgnoredGroup(String group) {
        return this.stringLiteralCharacter != null && group.charAt(0) == this.stringLiteralCharacter.charValue() && group.charAt(group.length() - 1) == this.stringLiteralCharacter.charValue();
    }

    private Map<String, Object> createNonRecursedMap(String[] groups) {
        LinkedHashMap<String, Object> nonRecursedMap = new LinkedHashMap<String, Object>();
        for (String group : groups) {
            Object value;
            if (this.isIgnoredGroup(group)) {
                if (!this.validKeyAndValue(group, null)) continue;
                nonRecursedMap.put(group, null);
                continue;
            }
            String[] terms = this.keyValueDelimiterPattern.split(group, 2);
            String key = terms[0];
            if (terms.length == 2) {
                value = terms[1];
            } else {
                LOG.debug("Unsuccessful match: '{}'", (Object)terms[0]);
                value = this.keyValueProcessorConfig.getNonMatchValue();
            }
            if (nonRecursedMap.containsKey(key)) {
                ArrayList<Object> valueList;
                Object existingValue = nonRecursedMap.get(key);
                if (existingValue instanceof List) {
                    valueList = (ArrayList<Object>)existingValue;
                } else {
                    valueList = new ArrayList<Object>();
                    valueList.add(existingValue);
                    if (this.validKeyAndValue(key, valueList)) {
                        nonRecursedMap.put(key, valueList);
                    }
                }
                if (this.keyValueProcessorConfig.getSkipDuplicateValues()) {
                    if (valueList.contains(value)) continue;
                    valueList.add(value);
                    continue;
                }
                valueList.add(value);
                continue;
            }
            if (!this.validKeyAndValue(key, value)) continue;
            nonRecursedMap.put(key, value);
        }
        return nonRecursedMap;
    }

    private Map<String, Object> executeConfigs(Map<String, Object> map) {
        Object key;
        HashMap<String, Object> processed = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            key = entry.getKey();
            Object value = entry.getValue();
            if (!this.includeKeysSet.isEmpty() && !this.includeKeysSet.contains(key)) {
                LOG.debug("Skipping not included key: '{}'", key);
                continue;
            }
            if (this.excludeKeysSet.contains(key)) {
                LOG.debug("Key is being excluded: '{}'", key);
                continue;
            }
            if (this.keyValueProcessorConfig.getDeleteKeyRegex() != null && !Objects.equals(this.keyValueProcessorConfig.getDeleteKeyRegex(), "")) {
                key = ((String)key).replaceAll(this.keyValueProcessorConfig.getDeleteKeyRegex(), "");
            }
            key = this.keyPrefix + (String)key;
            if (value != null && value instanceof String && this.keyValueProcessorConfig.getDeleteValueRegex() != null && !Objects.equals(this.keyValueProcessorConfig.getDeleteValueRegex(), "")) {
                value = ((String)value).replaceAll(this.keyValueProcessorConfig.getDeleteValueRegex(), "");
            }
            if (this.keyValueProcessorConfig.getWhitespace() == WhitespaceOption.STRICT) {
                String[] whitespace_arr = this.trimWhitespace((String)key, value);
                key = whitespace_arr[0];
                value = whitespace_arr[1];
            }
            if (this.keyValueProcessorConfig.getTransformKey() != null && this.keyValueProcessorConfig.getTransformKey() != TransformOption.NONE) {
                key = this.transformKey((String)key);
            }
            if (this.keyValueProcessorConfig.getRemoveBrackets()) {
                String bracketRegex = "[\\[\\]()<>]";
                if (value != null) {
                    value = value.toString().replaceAll("[\\[\\]()<>]", "");
                }
            }
            this.addKeyValueToMap(processed, (String)key, value);
        }
        for (Map.Entry<String, Object> pair : this.defaultValuesMap.entrySet()) {
            if (processed.containsKey(pair.getKey())) {
                LOG.debug("Skipping already included default key: '{}'", (Object)pair.getKey());
                continue;
            }
            if (!this.validKeyAndValue(pair.getKey(), pair.getValue())) continue;
            key = pair.getKey();
            processed.put((String)key, pair.getValue());
        }
        return processed;
    }

    private String[] trimWhitespace(String key, Object value) {
        String[] arr = new String[]{key.stripTrailing(), value.toString().stripLeading()};
        return arr;
    }

    private String transformKey(String key) {
        return (String)this.keyValueProcessorConfig.getTransformKey().getTransformFunction().apply(key);
    }

    private boolean validKeyAndValue(String key, Object value) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        return !this.keyValueProcessorConfig.getDropKeysWithNoValue() || value != null;
    }

    private void addKeyValueToMap(Map<String, Object> parsedMap, String key, Object value) {
        List valueAsList;
        Object processedValue = value;
        if (!this.validKeyAndValue(key, value)) {
            return;
        }
        if (value instanceof List && (valueAsList = (List)value).size() == 1) {
            processedValue = valueAsList.get(0);
        }
        if (!parsedMap.containsKey(key)) {
            parsedMap.put(key, processedValue);
            return;
        }
        if (parsedMap.get(key) instanceof List) {
            if (this.keyValueProcessorConfig.getSkipDuplicateValues() && ((List)parsedMap.get(key)).contains(processedValue)) {
                return;
            }
            ((List)parsedMap.get(key)).add(processedValue);
        } else {
            if (this.keyValueProcessorConfig.getSkipDuplicateValues() && parsedMap.containsValue(processedValue)) {
                return;
            }
            LinkedList<Object> combinedList = new LinkedList<Object>();
            combinedList.add(parsedMap.get(key));
            combinedList.add(processedValue);
            parsedMap.replace(key, combinedList);
        }
    }

    private void writeToRoot(Event event, Map<String, Object> parsedJson) {
        for (Map.Entry<String, Object> entry : parsedJson.entrySet()) {
            try {
                if (!this.keyValueProcessorConfig.getOverwriteIfDestinationExists() && event.containsKey(entry.getKey())) continue;
                event.put(entry.getKey(), entry.getValue(), this.normalizeKeys);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Failed to put key: " + entry.getKey() + " value : " + String.valueOf(entry.getValue()) + " into event. ", (Throwable)e);
            }
        }
    }
}

