/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.BeginsWithConditional;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.BetweenConditional;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.EqualToConditional;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.SingleKeyItemConditional;

@SdkPublicApi
@ThreadSafe
public interface QueryConditional {
    public static QueryConditional keyEqualTo(Key key) {
        return new EqualToConditional(key);
    }

    public static QueryConditional keyEqualTo(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.keyEqualTo(builder.build());
    }

    public static QueryConditional sortGreaterThan(Key key) {
        return new SingleKeyItemConditional(key, ">");
    }

    public static QueryConditional sortGreaterThan(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.sortGreaterThan(builder.build());
    }

    public static QueryConditional sortGreaterThanOrEqualTo(Key key) {
        return new SingleKeyItemConditional(key, ">=");
    }

    public static QueryConditional sortGreaterThanOrEqualTo(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.sortGreaterThanOrEqualTo(builder.build());
    }

    public static QueryConditional sortLessThan(Key key) {
        return new SingleKeyItemConditional(key, "<");
    }

    public static QueryConditional sortLessThan(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.sortLessThan(builder.build());
    }

    public static QueryConditional sortLessThanOrEqualTo(Key key) {
        return new SingleKeyItemConditional(key, "<=");
    }

    public static QueryConditional sortLessThanOrEqualTo(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.sortLessThanOrEqualTo(builder.build());
    }

    public static QueryConditional sortBetween(Key keyFrom, Key keyTo) {
        return new BetweenConditional(keyFrom, keyTo);
    }

    public static QueryConditional sortBetween(Consumer<Key.Builder> keyFromConsumer, Consumer<Key.Builder> keyToConsumer) {
        Key.Builder builderFrom = Key.builder();
        Key.Builder builderTo = Key.builder();
        keyFromConsumer.accept(builderFrom);
        keyToConsumer.accept(builderTo);
        return QueryConditional.sortBetween(builderFrom.build(), builderTo.build());
    }

    public static QueryConditional sortBeginsWith(Key key) {
        return new BeginsWithConditional(key);
    }

    public static QueryConditional sortBeginsWith(Consumer<Key.Builder> keyConsumer) {
        Key.Builder builder = Key.builder();
        keyConsumer.accept(builder);
        return QueryConditional.sortBeginsWith(builder.build());
    }

    public Expression expression(TableSchema<?> var1, String var2);
}

