/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.sourcecoordination.enhanced;

import io.micrometer.core.instrument.Counter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.parser.model.SourceCoordinationConfig;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.source.SourceCoordinationStore;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStatus;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedLeaseBasedSourceCoordinator
implements EnhancedSourceCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(EnhancedLeaseBasedSourceCoordinator.class);
    static final String PARTITIONS_COMPLETED_COUNT = "partitionsComplete";
    static final String PARTITION_CREATED_COUNT = "partitionsCreated";
    private static final Duration DEFAULT_LEASE_TIMEOUT = Duration.ofMinutes(10L);
    private static final String DEFAULT_GLOBAL_STATE_PARTITION_TYPE = "GLOBAL";
    private final SourceCoordinationStore coordinationStore;
    private final String sourceIdentifier;
    private final Function<SourcePartitionStoreItem, EnhancedSourcePartition> partitionFactory;
    private final PluginMetrics pluginMetrics;
    private final String partitionPrefix;
    private final Counter partitionsCreatedCounter;
    private final Counter partitionsCompletedCounter;
    static final String hostName;

    public EnhancedLeaseBasedSourceCoordinator(SourceCoordinationStore coordinationStore, SourceCoordinationConfig sourceCoordinationConfig, PluginMetrics pluginMetrics, String sourceIdentifier, Function<SourcePartitionStoreItem, EnhancedSourcePartition> partitionFactory) {
        this.coordinationStore = coordinationStore;
        this.sourceIdentifier = Objects.nonNull(sourceCoordinationConfig.getPartitionPrefix()) ? sourceCoordinationConfig.getPartitionPrefix() + "|" + sourceIdentifier : sourceIdentifier;
        this.pluginMetrics = pluginMetrics;
        this.partitionFactory = partitionFactory;
        this.partitionPrefix = sourceCoordinationConfig.getPartitionPrefix();
        this.partitionsCreatedCounter = pluginMetrics.counter(PARTITION_CREATED_COUNT);
        this.partitionsCompletedCounter = pluginMetrics.counter(PARTITIONS_COMPLETED_COUNT);
    }

    public void initialize() {
        this.coordinationStore.initializeStore();
    }

    public <T> boolean createPartition(EnhancedSourcePartition<T> partition) {
        String partitionType = partition.getPartitionType() == null ? DEFAULT_GLOBAL_STATE_PARTITION_TYPE : partition.getPartitionType();
        SourcePartitionStatus status = partition.getPartitionType() == null ? null : SourcePartitionStatus.UNASSIGNED;
        boolean partitionCreated = this.coordinationStore.tryCreatePartitionItem(this.sourceIdentifier + "|" + partitionType, partition.getPartitionKey(), status, Long.valueOf(0L), partition.convertPartitionProgressStatetoString(partition.getProgressState()), partition.getPartitionType() == null);
        if (partitionCreated) {
            this.partitionsCreatedCounter.increment();
        }
        return partitionCreated;
    }

    public Optional<EnhancedSourcePartition> acquireAvailablePartition(String partitionType) {
        Objects.requireNonNull(partitionType);
        LOG.debug("Try to acquire an available {} partition", (Object)partitionType);
        Optional sourceItem = this.coordinationStore.tryAcquireAvailablePartition(this.sourceIdentifier + "|" + partitionType, hostName, DEFAULT_LEASE_TIMEOUT);
        if (sourceItem.isEmpty()) {
            LOG.debug("Partition owner {} failed to acquire a partition, no available {} partitions now", (Object)hostName, (Object)partitionType);
            return Optional.empty();
        }
        return Optional.of(this.partitionFactory.apply((SourcePartitionStoreItem)sourceItem.get()));
    }

    public List<EnhancedSourcePartition> queryCompletedPartitions(String partitionType, Instant fromCompletionTime) {
        Objects.requireNonNull(partitionType);
        LOG.debug("Try to query a list of completed {} partitions", (Object)partitionType);
        long startTime = System.currentTimeMillis();
        List sourcePartitionStoreItems = this.coordinationStore.querySourcePartitionItemsByStatus(this.sourceIdentifier + "|" + partitionType, SourcePartitionStatus.COMPLETED, fromCompletionTime.toString());
        List<EnhancedSourcePartition> sourcePartitions = sourcePartitionStoreItems.stream().map(sourcePartitionStoreItem -> this.partitionFactory.apply((SourcePartitionStoreItem)sourcePartitionStoreItem)).collect(Collectors.toList());
        long endTime = System.currentTimeMillis();
        LOG.info("Query of completed partitions took {} milliseconds with {} items found", (Object)(endTime - startTime), (Object)sourcePartitions.size());
        return sourcePartitions;
    }

    public List<EnhancedSourcePartition> queryAllPartitions(String partitionType) {
        Objects.requireNonNull(partitionType);
        LOG.debug("Try to query all {} partitions", (Object)partitionType);
        long startTime = System.currentTimeMillis();
        List sourcePartitionStoreItems = this.coordinationStore.queryAllSourcePartitionItems(this.sourceIdentifier + "|" + partitionType);
        List<EnhancedSourcePartition> sourcePartitions = sourcePartitionStoreItems.stream().map(this.partitionFactory).collect(Collectors.toList());
        long endTime = System.currentTimeMillis();
        LOG.info("Query of partitions took {} milliseconds with {} items found", (Object)(endTime - startTime), (Object)sourcePartitions.size());
        return sourcePartitions;
    }

    public <T> void saveProgressStateForPartition(EnhancedSourcePartition<T> partition, Duration ownershipTimeoutRenewal) {
        String partitionType = partition.getPartitionType() == null ? DEFAULT_GLOBAL_STATE_PARTITION_TYPE : partition.getPartitionType();
        LOG.debug("Try to save progress for partition {} (Type {})", (Object)partition.getPartitionKey(), (Object)partitionType);
        if (partition.getSourcePartitionStoreItem() == null) {
            LOG.error("Unable to save progress, the item was not found.");
            return;
        }
        SourcePartitionStoreItem updateItem = partition.getSourcePartitionStoreItem();
        if (updateItem.getPartitionOwnershipTimeout() != null) {
            updateItem.setPartitionOwnershipTimeout(Instant.now().plus(ownershipTimeoutRenewal == null ? DEFAULT_LEASE_TIMEOUT : ownershipTimeoutRenewal));
        }
        updateItem.setPartitionProgressState(partition.convertPartitionProgressStatetoString(partition.getProgressState()));
        this.coordinationStore.tryUpdateSourcePartitionItem(updateItem);
        LOG.debug("Progress for for partition {} (Type {}) was saved", (Object)partition.getPartitionKey(), (Object)partitionType);
    }

    public <T> void giveUpPartition(EnhancedSourcePartition<T> partition) {
        Objects.requireNonNull(partition.getPartitionType());
        LOG.debug("Try to give up the ownership for partition {} (Type {})", (Object)partition.getPartitionKey(), (Object)partition.getPartitionType());
        if (partition.getSourcePartitionStoreItem() == null) {
            LOG.error("Unable to give up ownership, the item was not found.");
            return;
        }
        SourcePartitionStoreItem updateItem = partition.getSourcePartitionStoreItem();
        updateItem.setSourcePartitionStatus(SourcePartitionStatus.UNASSIGNED);
        updateItem.setPartitionOwner(null);
        updateItem.setPartitionOwnershipTimeout(null);
        this.coordinationStore.tryUpdateSourcePartitionItem(updateItem);
        LOG.debug("Partition key {} was given up by owner {}", (Object)partition.getPartitionKey(), (Object)hostName);
    }

    public <T> void completePartition(EnhancedSourcePartition<T> partition) {
        Objects.requireNonNull(partition.getPartitionType());
        LOG.debug("Try to complete partition {} (Type {})", (Object)partition.getPartitionKey(), (Object)partition.getPartitionType());
        if (partition.getSourcePartitionStoreItem() == null) {
            LOG.error("Unable to complete, the item is not found.");
            return;
        }
        SourcePartitionStoreItem updateItem = partition.getSourcePartitionStoreItem();
        updateItem.setPartitionOwner(null);
        updateItem.setReOpenAt(null);
        updateItem.setPartitionOwnershipTimeout(null);
        updateItem.setSourcePartitionStatus(SourcePartitionStatus.COMPLETED);
        updateItem.setPartitionProgressState(partition.convertPartitionProgressStatetoString(partition.getProgressState()));
        this.coordinationStore.tryUpdateSourcePartitionItem(updateItem);
        this.partitionsCompletedCounter.increment();
    }

    public <T> void closePartition(EnhancedSourcePartition<T> partition, Duration reopenAfter, int maxClosedCount) {
        Objects.requireNonNull(partition.getPartitionType());
        LOG.debug("Try to close partition {} (Type {})", (Object)partition.getPartitionKey(), (Object)partition.getPartitionType());
        if (partition.getSourcePartitionStoreItem() == null) {
            LOG.error("Unable to close, the item is not found.");
            return;
        }
        SourcePartitionStoreItem updateItem = partition.getSourcePartitionStoreItem();
        updateItem.setPartitionOwner(null);
        updateItem.setPartitionOwnershipTimeout(null);
        updateItem.setPartitionProgressState(partition.convertPartitionProgressStatetoString(partition.getProgressState()));
        updateItem.setClosedCount(Long.valueOf(updateItem.getClosedCount() + 1L));
        if (updateItem.getClosedCount() >= (long)maxClosedCount) {
            updateItem.setSourcePartitionStatus(SourcePartitionStatus.COMPLETED);
            updateItem.setReOpenAt(null);
        } else {
            updateItem.setSourcePartitionStatus(SourcePartitionStatus.CLOSED);
            updateItem.setReOpenAt(Instant.now().plus(reopenAfter));
        }
        this.coordinationStore.tryUpdateSourcePartitionItem(updateItem);
    }

    public Optional<EnhancedSourcePartition> getPartition(String partitionKey) {
        Optional sourceItem = this.coordinationStore.getSourcePartitionItem(this.sourceIdentifier + "|GLOBAL", partitionKey);
        if (!sourceItem.isPresent()) {
            LOG.warn("Global partition item with sourcePartitionKey '{}' could not be found.", (Object)partitionKey);
            return Optional.empty();
        }
        return Optional.of(this.partitionFactory.apply((SourcePartitionStoreItem)sourceItem.get()));
    }

    public String getPartitionPrefix() {
        return this.partitionPrefix;
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

