/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.sourcecoordination;

import java.util.function.Function;
import org.opensearch.dataprepper.core.parser.model.SourceCoordinationConfig;
import org.opensearch.dataprepper.core.sourcecoordination.LeaseBasedSourceCoordinator;
import org.opensearch.dataprepper.core.sourcecoordination.enhanced.EnhancedLeaseBasedSourceCoordinator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.source.SourceCoordinationStore;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceCoordinatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SourceCoordinatorFactory.class);
    private static final String SOURCE_COORDINATOR_PLUGIN_NAME_FOR_METRICS = "source-coordinator";
    private final SourceCoordinationConfig sourceCoordinationConfig;
    private final PluginFactory pluginFactory;

    public SourceCoordinatorFactory(SourceCoordinationConfig sourceCoordinationConfig, PluginFactory pluginFactory) {
        this.sourceCoordinationConfig = sourceCoordinationConfig;
        this.pluginFactory = pluginFactory;
    }

    public <T> SourceCoordinator<T> provideSourceCoordinator(Class<T> clazz, String subPipelineName) {
        if (this.sourceCoordinationConfig == null || this.sourceCoordinationConfig.getSourceCoordinationStoreConfig() == null || this.sourceCoordinationConfig.getSourceCoordinationStoreConfig().getName() == null) {
            return null;
        }
        SourceCoordinationStore sourceCoordinationStore = (SourceCoordinationStore)this.pluginFactory.loadPlugin(SourceCoordinationStore.class, this.sourceCoordinationConfig.getSourceCoordinationStoreConfig(), new Object[0]);
        PluginMetrics sourceCoordinatorMetrics = PluginMetrics.fromNames((String)SOURCE_COORDINATOR_PLUGIN_NAME_FOR_METRICS, (String)subPipelineName);
        LOG.info("Creating LeaseBasedSourceCoordinator with coordination store {} for sub-pipeline {}", (Object)this.sourceCoordinationConfig.getSourceCoordinationStoreConfig().getName(), (Object)subPipelineName);
        return new LeaseBasedSourceCoordinator<T>(clazz, sourceCoordinationStore, this.sourceCoordinationConfig, subPipelineName, sourceCoordinatorMetrics);
    }

    public EnhancedSourceCoordinator provideEnhancedSourceCoordinator(Function<SourcePartitionStoreItem, EnhancedSourcePartition> partitionFactory, String subPipelineName) {
        if (this.sourceCoordinationConfig == null || this.sourceCoordinationConfig.getSourceCoordinationStoreConfig() == null || this.sourceCoordinationConfig.getSourceCoordinationStoreConfig().getName() == null) {
            return null;
        }
        SourceCoordinationStore sourceCoordinationStore = (SourceCoordinationStore)this.pluginFactory.loadPlugin(SourceCoordinationStore.class, this.sourceCoordinationConfig.getSourceCoordinationStoreConfig(), new Object[0]);
        PluginMetrics sourceCoordinatorMetrics = PluginMetrics.fromNames((String)SOURCE_COORDINATOR_PLUGIN_NAME_FOR_METRICS, (String)subPipelineName);
        LOG.info("Creating EnhancedLeaseBasedSourceCoordinator with coordination store {} for sub-pipeline {}", (Object)this.sourceCoordinationConfig.getSourceCoordinationStoreConfig().getName(), (Object)subPipelineName);
        return new EnhancedLeaseBasedSourceCoordinator(sourceCoordinationStore, this.sourceCoordinationConfig, sourceCoordinatorMetrics, subPipelineName, partitionFactory);
    }
}

